<?php
 $page_title = "Test WhatsApp API";
 $page_subtitle = "Halaman untuk menguji pengiriman pesan ke satu nomor.";

require_once '../includes/header.php';

// --- Variabel untuk menyimpan hasil ---
 $message_result = '';
 $error_message = '';

// --- Proses jika form dikirim ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Ambil data dari form
    $target_phone = $_POST['target_phone'] ?? '';
    $message_text = $_POST['message_text'] ?? '';
    $image_url = $_POST['image_url'] ?? '';

    // Validasi sederhana
    if (empty(FONNTE_API_TOKEN) || FONNTE_API_TOKEN === 'YOUR_API_TOKEN_HERE') {
        $error_message = "API Token Fonnte belum diatur di config.php.";
    } elseif (empty($target_phone) || (empty($message_text) && empty($image_url) && empty($_FILES['image_file']['name']))) {
        $error_message = "Nomor telepon dan pesan/gambar tidak boleh kosong.";
    } else {
        // --- Mulai proses cURL berdasarkan contoh Fonnte ---
        $curl = curl_init();

        // Siapkan data untuk dikirim (sesuai contoh)
        $post_fields = [
            'target' => $target_phone,
            'message' => $message_text,
            'countryCode' => '62'
        ];

        // Handle upload gambar dari komputer atau URL
        if (isset($_FILES['image_file']) && $_FILES['image_file']['error'] == UPLOAD_ERR_OK) {
            $post_fields['file'] = new CURLFile($_FILES['image_file']['tmp_name'], $_FILES['image_file']['type'], $_FILES['image_file']['name']);
        } elseif (!empty($image_url)) {
            $post_fields['url'] = $image_url;
        }

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.fonnte.com/send',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $post_fields,
            CURLOPT_HTTPHEADER => array(
                'Authorization: ' . FONNTE_API_TOKEN
            ),
        ));

        $response = curl_exec($curl);
        
        if (curl_errno($curl)) {
            $error_message = "cURL Error: " . curl_error($curl);
        }
        
        curl_close($curl);

        if (empty($error_message)) {
            $message_result = $response;
        }
    }
}
?>

<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <h2 class="text-lg font-semibold text-gray-800 mb-4">Form Test Pengiriman</h2>
    
    <form action="test_wa" method="POST" enctype="multipart/form-data" class="space-y-4">
        <div>
            <label for="target_phone" class="block text-sm font-medium text-gray-700 mb-1">Nomor Target</label>
            <input type="text" id="target_phone" name="target_phone" placeholder="08123456789" required
                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-600">
        </div>

        <div>
            <label for="message_text" class="block text-sm font-medium text-gray-700 mb-1">Pesan Teks</label>
            <textarea id="message_text" name="message_text" rows="4" placeholder="Halo, ini adalah pesan test."
                      class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-600"></textarea>
        </div>
        
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Gambar (Opsional)</label>
            
            <div class="mb-2">
                <label class="block text-xs text-gray-600">Opsi 1: Upload dari Komputer</label>
                <input type="file" id="image_file" name="image_file" accept="image/*" class="w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100">
            </div>

            <div>
                <label class="block text-xs text-gray-600">Opsi 2: Masukkan URL Gambar</label>
                <input type="url" id="image_url" name="image_url" placeholder="https://example.com/gambar.jpg"
                       class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-600">
            </div>
        </div>

        <button type="submit" class="w-full bg-indigo-600 hover:bg-indigo-700 text-white font-bold py-2 px-4 rounded-lg transition duration-300">
            <i class="fas fa-paper-plane mr-2"></i> Kirim Pesan Test
        </button>
    </form>
</div>

<!-- Hasil / Error -->
<?php if ($error_message): ?>
    <div class="glass-card rounded-xl p-6 mb-6 fade-in bg-red-50 border border-red-200">
        <h2 class="text-lg font-semibold text-red-800 mb-2"><i class="fas fa-exclamation-triangle mr-2"></i> Terjadi Error</h2>
        <p class="text-red-700"><?php echo htmlspecialchars($error_message); ?></p>
    </div>
<?php endif; ?>

<?php if ($message_result): ?>
    <div class="glass-card rounded-xl p-6 mb-6 fade-in bg-green-50 border border-green-200">
        <h2 class="text-lg font-semibold text-green-800 mb-2"><i class="fas fa-check-circle mr-2"></i> Respon dari Server Fonnte</h2>
        <p class="text-sm text-gray-600 mb-3">Lihat respons di bawah untuk mengetahui status pengiriman.</p>
        <pre class="bg-white p-4 rounded border border-gray-300 text-sm overflow-x-auto"><?php echo htmlspecialchars($message_result); ?></pre>
    </div>
<?php endif; ?>

<?php require_once '../includes/footer.php'; ?>