<?php
// Set header untuk response JSON
header('Content-Type: application/json');

// Start session untuk mendapatkan data user
session_start();

// Cek apakah user sudah login
if (!isset($_SESSION['name'])) {
    echo json_encode([
        'success' => false,
        'message' => 'User tidak terautentikasi'
    ]);
    exit;
}

// Include file koneksi database
require_once '../config/database.php';

// Ambil data dari request
 $json = file_get_contents('php://input');
 $data = json_decode($json, true);

// Validasi data
if (!$data) {
    echo json_encode([
        'success' => false,
        'message' => 'Data tidak valid'
    ]);
    exit;
}

// Escape data untuk mencegah SQL Injection
 $spkNumber = isset($data['spkNumber']) ? $conn->real_escape_string($data['spkNumber']) : '';
 $policeNumber = isset($data['policeNumber']) ? $conn->real_escape_string($data['policeNumber']) : '';
 $customerName = isset($data['customerName']) ? $conn->real_escape_string($data['customerName']) : '';
 $phoneNumber = isset($data['phoneNumber']) ? $conn->real_escape_string($data['phoneNumber']) : '';
 $alamatPemilik = isset($data['alamatPemilik']) ? $conn->real_escape_string($data['alamatPemilik']) : '';
 $basicModel = isset($data['basicModel']) ? $conn->real_escape_string($data['basicModel']) : '';
 $type = isset($data['type']) ? $conn->real_escape_string($data['type']) : '';
 $transmisi = isset($data['transmisi']) ? $conn->real_escape_string($data['transmisi']) : '';
 $kategori = isset($data['kategori']) ? $conn->real_escape_string($data['kategori']) : '';
 $tahun = isset($data['tahun']) ? $conn->real_escape_string($data['tahun']) : '';
 $warna = isset($data['warna']) ? $conn->real_escape_string($data['warna']) : '';
 $vinNumber = isset($data['vinNumber']) ? $conn->real_escape_string($data['vinNumber']) : '';
 $noMesin = isset($data['noMesin']) ? $conn->real_escape_string($data['noMesin']) : '';
 $noBukuService = isset($data['noBukuService']) ? $conn->real_escape_string($data['noBukuService']) : '';
 $tahunRegistrasi = isset($data['tahunRegistrasi']) ? $conn->real_escape_string($data['tahunRegistrasi']) : '';
 $contactable = isset($data['contactable']) ? $conn->real_escape_string($data['contactable']) : '';
 $reason = isset($data['reason']) ? $conn->real_escape_string($data['reason']) : '';
 $bookingDate = isset($data['bookingDate']) ? $conn->real_escape_string($data['bookingDate']) : null;
 $bookingTime = isset($data['bookingTime']) ? $conn->real_escape_string($data['bookingTime']) : null;
 $reminderBy = $conn->real_escape_string($_SESSION['name']);

// Format tanggal dan waktu untuk booking
 $bookingDateTime = null;
if ($bookingDate && $bookingTime) {
    $bookingDateTime = $bookingDate . ' ' . $bookingTime . ':00';
}

// Query untuk menyimpan data ke tabel reminders
 $sql = "INSERT INTO reminders (
    spk_number, police_number, customer_name, phone_number, alamat_pemilik, 
    basic_model, type, transmisi, kategori, tahun, warna, vin_number, 
    no_mesin, no_buku_service, tahun_registrasi, contactable, reason, 
    booking_date_time, reminder_by, created_at
) VALUES (
    '$spkNumber', '$policeNumber', '$customerName', '$phoneNumber', '$alamatPemilik', 
    '$basicModel', '$type', '$transmisi', '$kategori', '$tahun', '$warna', '$vinNumber', 
    '$noMesin', '$noBukuService', '$tahunRegistrasi', '$contactable', '$reason', 
    " . ($bookingDateTime ? "'$bookingDateTime'" : "NULL") . ", '$reminderBy', NOW()
)";

// Eksekusi query
if ($conn->query($sql)) {
    echo json_encode([
        'success' => true,
        'message' => 'Reminder berhasil disimpan',
        'id' => $conn->insert_id
    ]);
} else {
    echo json_encode([
        'success' => false,
        'message' => 'Error: ' . $conn->error
    ]);
}

// Tutup koneksi
 $conn->close();
?>