<?php
 $page_title = "Pengaturan";
 $page_subtitle = "Kelola pengaturan sistem";

require_once '../includes/header.php';

// Get current settings
 $sql = "SELECT * FROM settings ORDER BY category, name";
 $result = $conn->query($sql);

 $settings = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $settings[$row['category']][] = $row;
    }
}

// Process form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    foreach ($_POST as $key => $value) {
        if (strpos($key, 'setting_') === 0) {
            $settingId = substr($key, 8);
            $value = sanitize_input($value);
            
            $sql = "UPDATE settings SET value = ? WHERE id = ?";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("si", $value, $settingId);
            $stmt->execute();
        }
    }
    
    $successMessage = "Pengaturan berhasil diperbarui";
    
    // Refresh settings data
    $result = $conn->query($sql);
    $settings = [];
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $settings[$row['category']][] = $row;
        }
    }
}
?>
<!-- Settings Form -->
<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold text-gray-800">Pengaturan Sistem</h2>
    </div>
    
    <?php if (isset($successMessage)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-6" role="alert">
            <span class="block sm:inline"><?php echo $successMessage; ?></span>
        </div>
    <?php endif; ?>
    
    <form method="POST" action="/pages/pengaturan.php">
        <?php foreach ($settings as $category => $categorySettings): ?>
        <div class="mb-8">
            <h3 class="text-md font-semibold text-gray-700 mb-4 border-b pb-2"><?php echo ucfirst($category); ?></h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <?php foreach ($categorySettings as $setting): ?>
                <div>
                    <label for="setting_<?php echo $setting['id']; ?>" class="block text-sm font-medium text-gray-700 mb-1">
                        <?php echo $setting['display_name']; ?>
                    </label>
                    <?php if ($setting['type'] == 'text'): ?>
                        <input type="text" id="setting_<?php echo $setting['id']; ?>" name="setting_<?php echo $setting['id']; ?>" value="<?php echo $setting['value']; ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                    <?php elseif ($setting['type'] == 'number'): ?>
                        <input type="number" id="setting_<?php echo $setting['id']; ?>" name="setting_<?php echo $setting['id']; ?>" value="<?php echo $setting['value']; ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                    <?php elseif ($setting['type'] == 'email'): ?>
                        <input type="email" id="setting_<?php echo $setting['id']; ?>" name="setting_<?php echo $setting['id']; ?>" value="<?php echo $setting['value']; ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                    <?php elseif ($setting['type'] == 'select'): ?>
                        <select id="setting_<?php echo $setting['id']; ?>" name="setting_<?php echo $setting['id']; ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                            <?php 
                            $options = explode(',', $setting['options']);
                            foreach ($options as $option): 
                                $option = trim($option);
                            ?>
                            <option value="<?php echo $option; ?>" <?php echo ($setting['value'] == $option) ? 'selected' : ''; ?>><?php echo ucfirst($option); ?></option>
                            <?php endforeach; ?>
                        </select>
                    <?php elseif ($setting['type'] == 'textarea'): ?>
                        <textarea id="setting_<?php echo $setting['id']; ?>" name="setting_<?php echo $setting['id']; ?>" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue"><?php echo $setting['value']; ?></textarea>
                    <?php endif; ?>
                    <?php if (!empty($setting['description'])): ?>
                        <p class="text-xs text-gray-500 mt-1"><?php echo $setting['description']; ?></p>
                    <?php endif; ?>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endforeach; ?>
        
        <div class="flex justify-end">
            <button type="submit" class="btn-primary px-6 py-2 text-white rounded-lg">
                <i class="fas fa-save mr-2"></i> Simpan Pengaturan
            </button>
        </div>
    </form>
</div>

<?php require_once '../includes/footer.php'; ?>