<?php
 $page_title = "Layanan";
 $page_subtitle = "Kelola layanan Suzuki";

require_once '../includes/header.php';

// Get service type from URL parameter
 $serviceType = isset($_GET['type']) ? sanitize_input($_GET['type']) : 'servis-berkala';

// Set page title based on service type
switch ($serviceType) {
    case 'servis-berkala':
        $page_title = "Servis Berkala";
        $page_subtitle = "Kelola jadwal servis berkala kendaraan";
        break;
    case 'body-repair':
        $page_title = "Body Repair";
        $page_subtitle = "Kelola layanan perbaikan body kendaraan";
        break;
    case 'detailing':
        $page_title = "Detailing";
        $page_subtitle = "Kelola layanan detailing kendaraan";
        break;
    case 'ganti-oli':
        $page_title = "Ganti Oli";
        $page_subtitle = "Kelola jadwal ganti oli kendaraan";
        break;
}

// Get filter parameters
 $search = isset($_GET['search']) ? sanitize_input($_GET['search']) : '';
 $status = isset($_GET['status']) ? sanitize_input($_GET['status']) : '';

// Build query
 $sql = "SELECT s.*, c.name as customer_name, v.model, v.license_plate 
        FROM services s 
        JOIN customers c ON s.customer_id = c.id 
        JOIN vehicles v ON s.vehicle_id = v.id 
        WHERE s.type = ?";

 $params = [$serviceType];
 $types = "s";

if (!empty($search)) {
    $sql .= " AND (c.name LIKE ? OR v.model LIKE ? OR v.license_plate LIKE ?)";
    $searchParam = "%$search%";
    $params[] = $searchParam;
    $params[] = $searchParam;
    $params[] = $searchParam;
    $types .= "sss";
}

if (!empty($status)) {
    $sql .= " AND s.status = ?";
    $params[] = $status;
    $types .= "s";
}

 $sql .= " ORDER BY s.service_date ASC";

// Prepare and execute query
 $stmt = $conn->prepare($sql);
 $stmt->bind_param($types, ...$params);
 $stmt->execute();
 $result = $stmt->get_result();

// Get status options
 $statusOptions = ['scheduled', 'in-progress', 'completed', 'cancelled'];
?>
<!-- Filter Section -->
<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Filter <?php echo $page_title; ?></h2>
        <button class="btn-primary px-3 py-1 text-white rounded-lg text-sm mt-2 md:mt-0" onclick="addNewService()">
            <i class="fas fa-plus mr-1"></i> Tambah Layanan
        </button>
    </div>
    
    <form method="GET" action="/pages/layanan.php" class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <input type="hidden" name="type" value="<?php echo $serviceType; ?>">
        
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Pencarian</label>
            <input type="text" name="search" value="<?php echo $search; ?>" placeholder="Nama, model, atau plat nomor" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
        </div>
        
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
            <select name="status" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                <option value="">Semua Status</option>
                <?php foreach ($statusOptions as $s): ?>
                <option value="<?php echo $s; ?>" <?php echo ($status == $s) ? 'selected' : ''; ?>><?php echo ucwords(str_replace('-', ' ', $s)); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div class="flex items-end">
            <button type="submit" class="w-full btn-primary px-4 py-2 text-white rounded-lg">
                <i class="fas fa-search mr-2"></i> Cari
            </button>
        </div>
    </form>
</div>

<!-- Services Table -->
<div class="glass-card rounded-xl p-6 fade-in">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Daftar <?php echo $page_title; ?></h2>
        <div class="text-sm text-gray-500">
            Menampilkan <?php echo $result->num_rows; ?> data
        </div>
    </div>
    
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead>
                <tr class="text-left text-xs text-gray-500 uppercase tracking-wider border-b">
                    <th class="pb-3">Konsumen</th>
                    <th class="pb-3">Kendaraan</th>
                    <th class="pb-3">Tanggal</th>
                    <th class="pb-3">Deskripsi</th>
                    <th class="pb-3">Biaya</th>
                    <th class="pb-3">Status</th>
                    <th class="pb-3">Aksi</th>
                </tr>
            </thead>
            <tbody class="text-sm">
                <?php if ($result->num_rows > 0): ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                    <tr class="table-row border-b">
                        <td class="py-3">
                            <div class="flex items-center">
                                <img src="https://picsum.photos/seed/<?php echo $row['customer_name']; ?>/32/32.jpg" alt="User" class="w-8 h-8 rounded-lg mr-2">
                                <div>
                                    <p class="font-medium text-gray-800"><?php echo $row['customer_name']; ?></p>
                                </div>
                            </div>
                        </td>
                        <td class="py-3">
                            <p class="font-medium text-gray-800"><?php echo $row['model']; ?></p>
                            <p class="text-xs text-gray-500"><?php echo $row['license_plate']; ?></p>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo date('d M Y', strtotime($row['service_date'])); ?></p>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo $row['description']; ?></p>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800">Rp <?php echo number_format($row['cost'], 0, ',', '.'); ?></p>
                        </td>
                        <td class="py-3">
                            <?php
                            $statusClass = '';
                            $statusText = '';
                            
                            switch ($row['status']) {
                                case 'scheduled':
                                    $statusClass = 'bg-blue-100 text-blue-700';
                                    $statusText = 'Terjadwal';
                                    break;
                                case 'in-progress':
                                    $statusClass = 'bg-yellow-100 text-yellow-700';
                                    $statusText = 'Dalam Proses';
                                    break;
                                case 'completed':
                                    $statusClass = 'bg-green-100 text-green-700';
                                    $statusText = 'Selesai';
                                    break;
                                case 'cancelled':
                                    $statusClass = 'bg-red-100 text-red-700';
                                    $statusText = 'Dibatalkan';
                                    break;
                            }
                            ?>
                            <span class="badge px-2 py-1 text-xs rounded-full <?php echo $statusClass; ?>"><?php echo $statusText; ?></span>
                        </td>
                        <td class="py-3">
                            <div class="flex space-x-2">
                                <button class="text-suzuki-blue hover:text-suzuki-dark" onclick="viewService(<?php echo $row['id']; ?>)">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <button class="text-green-600 hover:text-green-800" onclick="editService(<?php echo $row['id']; ?>)">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="text-red-600 hover:text-red-800" onclick="deleteService(<?php echo $row['id']; ?>)">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" class="py-8 text-center text-gray-500">
                            <i class="fas fa-wrench text-4xl mb-2"></i>
                            <p>Tidak ada data layanan</p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>