<?php
 $page_title = "Dashboard Reminder Konsumen";
 $page_subtitle = "Monitor dan kelola reminder konsumen";

require_once '../includes/header.php';

// Fetch dashboard data from database
 $totalReminders = 0;
 $todayReminders = 0;
 $totalCustomers = 0;
 $responseRate = 0;

// Get total reminders
 $sql = "SELECT COUNT(*) as count FROM reminders";
 $result = $conn->query($sql);
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $totalReminders = $row['count'];
}

// Get today's reminders
 $sql = "SELECT COUNT(*) as count FROM reminders WHERE DATE(due_date) = CURDATE()";
 $result = $conn->query($sql);
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $todayReminders = $row['count'];
}

// Get total customers
 $sql = "SELECT COUNT(*) as count FROM customers";
 $result = $conn->query($sql);
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $totalCustomers = $row['count'];
}

// Calculate response rate
 $sql = "SELECT 
    SUM(CASE WHEN status = 'completed' THEN 1 ELSE 0 END) as completed,
    COUNT(*) as total
    FROM reminders";
 $result = $conn->query($sql);
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    if ($row['total'] > 0) {
        $responseRate = round(($row['completed'] / $row['total']) * 100);
    }
}

// Get monthly progress
 $monthlyTarget = 200;
 $monthlyCompleted = 0;

 $sql = "SELECT COUNT(*) as count FROM reminders 
        WHERE MONTH(due_date) = MONTH(CURDATE()) 
        AND YEAR(due_date) = YEAR(CURDATE()) 
        AND status = 'completed'";
 $result = $conn->query($sql);
if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $monthlyCompleted = $row['count'];
}

 $monthlyProgress = round(($monthlyCompleted / $monthlyTarget) * 100);

// Get service types data
 $servisCount = 0;
 $asuransiCount = 0;
 $stnkCount = 0;

 $sql = "SELECT type, COUNT(*) as count FROM reminders 
        WHERE MONTH(due_date) = MONTH(CURDATE()) 
        AND YEAR(due_date) = YEAR(CURDATE())
        GROUP BY type";
 $result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        switch ($row['type']) {
            case 'servis':
                $servisCount = $row['count'];
                break;
            case 'asuransi':
                $asuransiCount = $row['count'];
                break;
            case 'stnk':
                $stnkCount = $row['count'];
                break;
        }
    }
}

// Get recent reminders
 $recentReminders = [];
 $sql = "SELECT r.id, c.name as customer_name, c.vehicle_model, r.type, r.status, r.due_date 
        FROM reminders r 
        JOIN customers c ON r.customer_id = c.id 
        ORDER BY r.created_at DESC 
        LIMIT 3";
 $result = $conn->query($sql);
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $recentReminders[] = $row;
    }
}
?>
<!-- Stats Cards -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
    <div class="glass-card rounded-xl p-5 fade-in">
        <div class="flex items-center justify-between mb-4">
            <div class="stat-icon bg-blue-100">
                <i class="fas fa-bell text-suzuki-blue text-xl"></i>
            </div>
            <span class="text-xs text-green-600 font-semibold">+12%</span>
        </div>
        <h3 class="text-2xl font-bold text-gray-800"><?php echo $totalReminders; ?></h3>
        <p class="text-gray-600 text-sm">Total Reminder</p>
        <div class="mini-chart">
            <div class="mini-bar" style="height: 60%; background: var(--suzuki-blue)"></div>
            <div class="mini-bar" style="height: 80%; background: var(--suzuki-blue)"></div>
            <div class="mini-bar" style="height: 45%; background: var(--suzuki-blue)"></div>
            <div class="mini-bar" style="height: 90%; background: var(--suzuki-blue)"></div>
            <div class="mini-bar" style="height: 70%; background: var(--suzuki-blue)"></div>
            <div class="mini-bar" style="height: 85%; background: var(--suzuki-blue)"></div>
            <div class="mini-bar" style="height: 75%; background: var(--suzuki-blue)"></div>
        </div>
    </div>
    
    <div class="glass-card rounded-xl p-5 fade-in" style="animation-delay: 0.1s">
        <div class="flex items-center justify-between mb-4">
            <div class="stat-icon bg-orange-100">
                <i class="fas fa-exclamation-triangle text-orange-600 text-xl"></i>
            </div>
            <span class="text-xs text-orange-600 font-semibold">Aktif</span>
        </div>
        <h3 class="text-2xl font-bold text-gray-800"><?php echo $todayReminders; ?></h3>
        <p class="text-gray-600 text-sm">Reminder Hari Ini</p>
        <div class="mini-chart">
            <div class="mini-bar" style="height: 40%; background: var(--suzuki-orange)"></div>
            <div class="mini-bar" style="height: 60%; background: var(--suzuki-orange)"></div>
            <div class="mini-bar" style="height: 80%; background: var(--suzuki-orange)"></div>
            <div class="mini-bar" style="height: 70%; background: var(--suzuki-orange)"></div>
            <div class="mini-bar" style="height: 90%; background: var(--suzuki-orange)"></div>
            <div class="mini-bar" style="height: 65%; background: var(--suzuki-orange)"></div>
            <div class="mini-bar" style="height: 75%; background: var(--suzuki-orange)"></div>
        </div>
    </div>
    
    <div class="glass-card rounded-xl p-5 fade-in" style="animation-delay: 0.2s">
        <div class="flex items-center justify-between mb-4">
            <div class="stat-icon bg-green-100">
                <i class="fas fa-users text-green-600 text-xl"></i>
            </div>
            <span class="text-xs text-green-600 font-semibold">+8%</span>
        </div>
        <h3 class="text-2xl font-bold text-gray-800"><?php echo number_format($totalCustomers); ?></h3>
        <p class="text-gray-600 text-sm">Konsumen Aktif</p>
        <div class="mini-chart">
            <div class="mini-bar" style="height: 50%; background: #10b981"></div>
            <div class="mini-bar" style="height: 70%; background: #10b981"></div>
            <div class="mini-bar" style="height: 65%; background: #10b981"></div>
            <div class="mini-bar" style="height: 80%; background: #10b981"></div>
            <div class="mini-bar" style="height: 75%; background: #10b981"></div>
            <div class="mini-bar" style="height: 85%; background: #10b981"></div>
            <div class="mini-bar" style="height: 90%; background: #10b981"></div>
        </div>
    </div>
    
    <div class="glass-card rounded-xl p-5 fade-in" style="animation-delay: 0.3s">
        <div class="flex items-center justify-between mb-4">
            <div class="stat-icon bg-purple-100">
                <i class="fas fa-chart-line text-purple-600 text-xl"></i>
            </div>
            <span class="text-xs text-green-600 font-semibold">+3%</span>
        </div>
        <h3 class="text-2xl font-bold text-gray-800"><?php echo $responseRate; ?>%</h3>
        <p class="text-gray-600 text-sm">Tingkat Respons</p>
        <div class="mini-chart">
            <div class="mini-bar" style="height: 70%; background: #8b5cf6"></div>
            <div class="mini-bar" style="height: 75%; background: #8b5cf6"></div>
            <div class="mini-bar" style="height: 80%; background: #8b5cf6"></div>
            <div class="mini-bar" style="height: 85%; background: #8b5cf6"></div>
            <div class="mini-bar" style="height: 82%; background: #8b5cf6"></div>
            <div class="mini-bar" style="height: 88%; background: #8b5cf6"></div>
            <div class="mini-bar" style="height: 92%; background: #8b5cf6"></div>
        </div>
    </div>
</div>

<!-- Progress Target -->
<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <div class="flex items-center justify-between mb-4">
        <div>
            <h2 class="text-lg font-semibold text-gray-800">Target Bulanan</h2>
            <p class="text-sm text-gray-500">Pencapaian reminder konsumen</p>
        </div>
        <div class="flex items-center space-x-2">
            <button class="px-3 py-1 text-sm bg-suzuki-blue text-white rounded-lg" onclick="changePeriod('week')">Minggu</button>
            <button class="px-3 py-1 text-sm bg-gray-100 text-gray-600 rounded-lg hover:bg-gray-200" onclick="changePeriod('month')">Bulan</button>
            <button class="px-3 py-1 text-sm bg-gray-100 text-gray-600 rounded-lg hover:bg-gray-200" onclick="changePeriod('year')">Tahun</button>
        </div>
    </div>
    
    <div class="mb-6">
        <div class="flex justify-between text-sm mb-2">
            <span class="text-gray-600">Progress</span>
            <span class="font-semibold text-suzuki-blue"><?php echo $monthlyCompleted; ?>/<?php echo $monthlyTarget; ?> (<?php echo $monthlyProgress; ?>%)</span>
        </div>
        <div class="w-full bg-gray-200 rounded-full h-3">
            <div class="progress-fill h-3 rounded-full" style="width: <?php echo $monthlyProgress; ?>%"></div>
        </div>
    </div>
    
    <div class="grid grid-cols-3 gap-4">
        <div class="text-center p-3 bg-blue-50 rounded-lg">
            <i class="fas fa-wrench text-suzuki-blue text-xl mb-2"></i>
            <p class="text-xl font-bold text-gray-800"><?php echo $servisCount; ?></p>
            <p class="text-xs text-gray-600">Servis</p>
        </div>
        <div class="text-center p-3 bg-orange-50 rounded-lg">
            <i class="fas fa-shield-alt text-orange-600 text-xl mb-2"></i>
            <p class="text-xl font-bold text-gray-800"><?php echo $asuransiCount; ?></p>
            <p class="text-xs text-gray-600">Asuransi</p>
        </div>
        <div class="text-center p-3 bg-green-50 rounded-lg">
            <i class="fas fa-id-card text-green-600 text-xl mb-2"></i>
            <p class="text-xl font-bold text-gray-800"><?php echo $stnkCount; ?></p>
            <p class="text-xs text-gray-600">STNK</p>
        </div>
    </div>
</div>

<!-- Charts and Table -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
    <!-- Chart -->
    <div class="glass-card rounded-xl p-6 fade-in">
        <div class="flex items-center justify-between mb-4">
            <div>
                <h2 class="text-lg font-semibold text-gray-800">Grafik Reminder</h2>
                <p class="text-sm text-gray-500">Performa mingguan</p>
            </div>
            <select class="text-sm border border-gray-200 rounded-lg px-3 py-1 focus:outline-none" onchange="updateChart(this.value)">
                <option value="7">7 Hari</option>
                <option value="30">30 Hari</option>
            </select>
        </div>
        <div style="height: 250px;">
            <canvas id="reminderChart"></canvas>
        </div>
    </div>
    
    <!-- Table -->
    <div class="glass-card rounded-xl p-6 fade-in">
        <div class="flex items-center justify-between mb-4">
            <div>
                <h2 class="text-lg font-semibold text-gray-800">Reminder Terbaru</h2>
                <p class="text-sm text-gray-500">Notifikasi terkini</p>
            </div>
            <button class="btn-primary px-3 py-1 text-white rounded-lg text-sm" onclick="addNewReminder()">
                <i class="fas fa-plus mr-1"></i> Tambah
            </button>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="text-left text-xs text-gray-500 uppercase tracking-wider border-b">
                        <th class="pb-3">Konsumen</th>
                        <th class="pb-3">Tipe</th>
                        <th class="pb-3">Status</th>
                        <th class="pb-3">Aksi</th>
                    </tr>
                </thead>
                <tbody class="text-sm">
                    <?php foreach ($recentReminders as $reminder): ?>
                    <tr class="table-row border-b">
                        <td class="py-3">
                            <div class="flex items-center">
                                <img src="https://picsum.photos/seed/<?php echo $reminder['customer_name']; ?>/32/32.jpg" alt="User" class="w-8 h-8 rounded-lg mr-2">
                                <div>
                                    <p class="font-medium text-gray-800"><?php echo $reminder['customer_name']; ?></p>
                                    <p class="text-xs text-gray-500"><?php echo $reminder['vehicle_model']; ?></p>
                                </div>
                            </div>
                        </td>
                        <td class="py-3">
                            <?php
                            $badgeClass = '';
                            $badgeText = '';
                            
                            switch ($reminder['type']) {
                                case 'servis':
                                    $badgeClass = 'bg-blue-100 text-blue-700';
                                    $badgeText = 'Servis';
                                    break;
                                case 'asuransi':
                                    $badgeClass = 'bg-orange-100 text-orange-700';
                                    $badgeText = 'Asuransi';
                                    break;
                                case 'stnk':
                                    $badgeClass = 'bg-green-100 text-green-700';
                                    $badgeText = 'STNK';
                                    break;
                            }
                            ?>
                            <span class="badge px-2 py-1 text-xs rounded-full <?php echo $badgeClass; ?>"><?php echo $badgeText; ?></span>
                        </td>
                        <td class="py-3">
                            <?php
                            $statusClass = '';
                            $statusText = '';
                            
                            switch ($reminder['status']) {
                                case 'pending':
                                    $statusClass = 'bg-yellow-100 text-yellow-700';
                                    $statusText = 'Menunggu';
                                    break;
                                case 'completed':
                                    $statusClass = 'bg-green-100 text-green-700';
                                    $statusText = 'Selesai';
                                    break;
                                case 'important':
                                    $statusClass = 'bg-orange-100 text-orange-700';
                                    $statusText = 'Penting';
                                    break;
                            }
                            ?>
                            <span class="badge px-2 py-1 text-xs rounded-full <?php echo $statusClass; ?>"><?php echo $statusText; ?></span>
                        </td>
                        <td class="py-3">
                            <button class="text-suzuki-blue hover:text-suzuki-dark" onclick="viewReminder(<?php echo $reminder['id']; ?>)">
                                <i class="fas fa-eye"></i>
                            </button>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>