<?php
 $page_title = "WhatsApp Blast";
 $page_subtitle = "Kirim pesan WhatsApp massal ke pelanggan";

require_once '../includes/header.php';

// --- PENYESUAIAN DATABASE ---
// Koneksi ke tabel 'penjualan' dan kolom yang sesuai
 $CUSTOMER_TABLE = 'penjualan'; // Nama tabel Anda
 $COL_ID = 'No Utama';           // Kolom ID (Primary Key)
 $COL_NAMA = 'Nama Customer';    // Kolom Nama Pelanggan
 $COL_TELEPON = 'No. Telepon';   // Kolom Nomor Telepon
 $COL_NOPOL = 'No. SPK';         // Kolom Nomor SPK
 $COL_INVOICE = 'No. Invoice';   // Kolom No. Invoice (menggantikan 'model')
// ---------------------------

// Fungsi untuk mengambil data pelanggan (via AJAX)
if (isset($_GET['get_customers'])) {
    header('Content-Type: application/json');
    
    $search = $_GET['search'] ?? '';

    // Bangun query pencarian. Kolom dengan spasi harus di-backtick (` `)
    $where_clause = "";
    $params = [];
    $types = "";

    if (!empty($search)) {
        $where_clause = "WHERE `$COL_NAMA` LIKE ? OR `$COL_TELEPON` LIKE ? OR `$COL_NOPOL` LIKE ?";
        $searchParam = "%$search%";
        $params = [$searchParam, $searchParam, $searchParam];
        $types = "sss";
    }

    // Kolom dengan spasi juga di-backtick di SELECT
    $sql = "SELECT `$COL_ID`, `$COL_NAMA`, `$COL_TELEPON`, `$COL_NOPOL`, `$COL_INVOICE` FROM `$CUSTOMER_TABLE` $where_clause ORDER BY `$COL_NAMA` ASC";
    $stmt = $conn->prepare($sql);
    if (!empty($params)) {
        $stmt->bind_param($types, ...$params);
    }
    $stmt->execute();
    $result = $stmt->get_result();

    $customers = [];
    if ($result && $result->num_rows > 0) {
        while($row = $result->fetch_assoc()) {
            // Pastikan nomor telepon tidak kosong
            if(!empty($row[$COL_TELEPON])) {
                $customers[] = $row;
            }
        }
    }
    echo json_encode($customers);
    exit;
}

// Fungsi untuk mengirim WhatsApp (via AJAX)
if (isset($_POST['send_message'])) {
    header('Content-Type: application/json');

    $recipient_ids = $_POST['recipients'] ?? [];
    $message_template = $_POST['message_template'] ?? '';
    $message_image = $_POST['message_image'] ?? '';

    if (empty(FONNTE_API_TOKEN)) {
        echo json_encode(['status' => 'error', 'message' => 'API Token Fonnte belum diatur.']);
        exit;
    }

    if (empty($recipient_ids) || (empty($message_template) && empty($message_image))) {
        echo json_encode(['status' => 'error', 'message' => 'Pilih penerima dan tulis pesan atau pilih gambar.']);
        exit;
    }

    // --- PERBARUI PLACEHOLDER SESUAI TABEL BARU ---
    $placeholders = ['{nama}', '{spk}', '{invoice}', '{telepon}'];
    $log = [];
    $success_count = 0;
    $failed_count = 0;

    // Siapkan statement untuk mengambil data pelanggan
    $sql_detail = "SELECT `$COL_NAMA`, `$COL_TELEPON`, `$COL_NOPOL`, `$COL_INVOICE` FROM `$CUSTOMER_TABLE` WHERE `$COL_ID` = ?";
    $stmt_detail = $conn->prepare($sql_detail);

    foreach ($recipient_ids as $id) {
        $stmt_detail->bind_param('i', $id);
        $stmt_detail->execute();
        $result_detail = $stmt_detail->get_result();
        $customer = $result_detail->fetch_assoc();

        if ($customer && !empty($customer[$COL_TELEPON])) {
            // Ganti placeholder dengan data yang sesuai
            $replacements = [
                $customer[$COL_NAMA],
                $customer[$COL_NOPOL],
                $customer[$COL_INVOICE],
                $customer[$COL_TELEPON]
            ];
            $final_message = str_replace($placeholders, $replacements, $message_template);

            // Format nomor telepon
            $target_phone = preg_replace('/^0/', '62', $customer[$COL_TELEPON]);

            // Kirim ke Fonnte API
            $curl = curl_init();
            $payload = [
                'target' => $target_phone,
            ];

            if (!empty($message_image)) {
                $payload['url'] = $message_image;
                $payload['message'] = $final_message;
            } else {
                $payload['message'] = $final_message;
            }

            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.fonnte.com/send',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => $payload,
                CURLOPT_HTTPHEADER => array(
                    'Authorization: ' . FONNTE_API_TOKEN
                ),
            ));

            $response = curl_exec($curl);
            $err = curl_error($curl);
            curl_close($curl);

            if ($err) {
                $log[] = ['recipient' => $customer[$COL_NAMA], 'status' => 'Gagal', 'message' => 'cURL Error: ' . $err];
                $failed_count++;
            } else {
                $result_json = json_decode($response, true);
                if (isset($result_json['status']) && $result_json['status'] == true) {
                    $log[] = ['recipient' => $customer[$COL_NAMA], 'status' => 'Sukses', 'message' => 'Terkirim.'];
                    $success_count++;
                } else {
                    $log_message = $result_json['reason'] ?? 'Gagal mengirim.';
                    $log[] = ['recipient' => $customer[$COL_NAMA], 'status' => 'Gagal', 'message' => $log_message];
                    $failed_count++;
                }
            }
        } else {
            $log[] = ['recipient' => 'ID ' . $id, 'status' => 'Gagal', 'message' => 'Data pelanggan atau nomor telepon tidak ditemukan.'];
            $failed_count++;
        }
    }

    echo json_encode([
        'status' => 'completed', 
        'success' => $success_count,
        'failed' => $failed_count,
        'log' => $log
    ]);
    exit;
}

// --- FUNGSI UNTUK TEST BLAST (sama seperti sebelumnya) ---
if (isset($_POST['send_test'])) {
    header('Content-Type: application/json');
    $test_phone_number = $_POST['test_phone_number'] ?? '';
    $message_template = $_POST['message_template'] ?? '';
    $message_image = $_POST['message_image'] ?? '';

    if (empty(FONNTE_API_TOKEN)) {
        echo json_encode(['status' => 'error', 'message' => 'API Token Fonnte belum diatur.']);
        exit;
    }

    if (empty($test_phone_number) || (empty($message_template) && empty($message_image))) {
        echo json_encode(['status' => 'error', 'message' => 'Masukkan nomor telepon dan tulis pesan atau pilih gambar.']);
        exit;
    }

    $target_phone = preg_replace('/^0/', '62', $test_phone_number);
    $curl = curl_init();
    $payload = ['target' => $target_phone];

    if (!empty($message_image)) {
        $payload['url'] = $message_image;
        $payload['message'] = $message_template;
    } else {
        $payload['message'] = $message_template;
    }

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://api.fonnte.com/send', CURLOPT_RETURNTRANSFER => true, CURLOPT_ENCODING => '', CURLOPT_MAXREDIRS => 10, CURLOPT_TIMEOUT => 0, CURLOPT_FOLLOWLOCATION => true, CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1, CURLOPT_CUSTOMREQUEST => 'POST', CURLOPT_POSTFIELDS => $payload, CURLOPT_HTTPHEADER => array( 'Authorization: ' . FONNTE_API_TOKEN ), ));
    $response = curl_exec($curl); $err = curl_error($curl); curl_close($curl);

    if ($err) { echo json_encode(['status' => 'error', 'message' => 'cURL Error: ' . $err]); } else {
        $result_json = json_decode($response, true);
        if (isset($result_json['status']) && $result_json['status'] == true) {
            echo json_encode(['status' => 'success', 'message' => 'Test pesan berhasil dikirim ke ' . $target_phone]);
        } else {
            $log_message = $result_json['reason'] ?? 'Gagal mengirim.';
            echo json_encode(['status' => 'error', 'message' => 'Gagal: ' . $log_message]);
        }
    }
    exit;
}
?>

<!-- Bagian Test Blast -->
<div class="glass-card rounded-xl p-6 mb-6 fade-in bg-yellow-50 border border-yellow-200">
    <h2 class="text-lg font-semibold text-gray-800 mb-4"><i class="fas fa-flask text-yellow-600 mr-2"></i> Kirim Test</h2>
    <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
        <div class="md:col-span-2">
            <label class="block text-sm font-medium text-gray-700 mb-1">Nomor Telepon Test</label>
            <input type="text" id="testPhoneNumber" placeholder="Contoh: 08123456789" 
                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-yellow-600">
        </div>
        <div>
            <button id="sendTestBtn" class="w-full px-4 py-2 bg-yellow-600 hover:bg-yellow-700 text-white font-semibold rounded-lg shadow-md transition duration-150 ease-in-out">
                <i class="fas fa-paper-plane mr-2"></i> Kirim Test
            </button>
        </div>
    </div>
</div>

<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <h2 class="text-lg font-semibold text-gray-800 mb-4">Tulis Pesan</h2>
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Template Pesan (Caption)</label>
            <textarea id="messageTemplate" rows="5" placeholder="Halo {nama}, kami mengingatkan untuk servis kendaraan Anda dengan No. SPK {spk}."
                      class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-600"></textarea>
            <!-- --- PERBARUI PENJELASAN PLACEHOLDER --- -->
            <p class="text-xs text-gray-500 mt-1">
                <strong>Placeholder yang tersedia:</strong> <code>{nama}</code> (Nama Customer), <code>{spk}</code> (No. SPK), <code>{invoice}</code> (No. Invoice), <code>{telepon}</code> (No. Telepon)
            </p>
        </div>
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Gambar (Opsional)</label>
            <input type="file" id="imageInput" accept="image/*" class="hidden">
            <button type="button" id="chooseImageBtn" class="px-4 py-2 bg-gray-200 hover:bg-gray-300 text-gray-800 font-medium rounded-lg transition-all">
                <i class="fas fa-image mr-2"></i> Pilih Gambar
            </button>
            <button type="button" id="removeImageBtn" class="ml-2 px-4 py-2 bg-red-100 hover:bg-red-200 text-red-700 font-medium rounded-lg transition-all" style="display:none;">
                <i class="fas fa-trash mr-2"></i> Hapus
            </button>
            
            <div id="imagePreview" class="mt-4 border-2 border-dashed border-gray-300 rounded-lg p-4 text-center" style="display:none;">
                <img src="" alt="Preview" class="mx-auto max-h-48 rounded-lg shadow-md">
                <p class="text-xs text-gray-500 mt-2">Preview Gambar</p>
            </div>
        </div>
    </div>
</div>

<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Daftar Penerima</h2>
        <div class="mt-2 md:mt-0">
            <input type="text" id="searchCustomer" placeholder="Cari nama atau telepon..." 
                   class="px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-600">
        </div>
    </div>
    <div id="customerListContainer">
        <p class="text-center text-gray-500 py-8"><i class="fas fa-spinner fa-spin mr-2"></i>Memuat data pelanggan...</p>
    </div>
</div>

<div class="glass-card rounded-xl p-6 fade-in">
    <button id="sendBlastBtn" class="w-full md:w-auto px-6 py-2 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg shadow-md transition duration-150 ease-in-out disabled:bg-gray-400 disabled:cursor-not-allowed">
        <i class="fas fa-paper-plane mr-2"></i> Kirim WhatsApp Blast
    </button>
</div>

<div id="sendLogContainer" class="glass-card rounded-xl p-6 mt-6 fade-in" style="display: none;">
    <h2 class="text-lg font-semibold text-gray-800 mb-4">Log Pengiriman</h2>
    <div id="sendLog" class="space-y-2 max-h-96 overflow-y-auto bg-gray-50 p-4 rounded-lg text-sm font-mono">
        <!-- Log akan muncul di sini -->
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // ... (JavaScript-nya sama persis dengan versi sebelumnya, tidak perlu diubah) ...
    // Karena JavaScript mengambil data dari JSON, dan key-nya sudah benar (No Utama, Nama Customer, dll)
    // maka JavaScript-nya akan bekerja dengan baik tanpa perubahan.
    // Saya akan menyalin seluruh bagian JavaScript di sini untuk kelengkapan.
    
    const sendTestBtn = document.getElementById('sendTestBtn');
    const sendBlastBtn = document.getElementById('sendBlastBtn');
    const customerListContainer = document.getElementById('customerListContainer');
    const messageTemplate = document.getElementById('messageTemplate');
    const sendLogContainer = document.getElementById('sendLogContainer');
    const sendLog = document.getElementById('sendLog');
    const searchInput = document.getElementById('searchCustomer');
    const testPhoneNumberInput = document.getElementById('testPhoneNumber');

    const imageInput = document.getElementById('imageInput');
    const chooseImageBtn = document.getElementById('chooseImageBtn');
    const removeImageBtn = document.getElementById('removeImageBtn');
    const imagePreview = document.getElementById('imagePreview');
    const imagePreviewImg = imagePreview.querySelector('img');

    let selectedImageData = null;
    let allCustomers = [];

    sendTestBtn.addEventListener('click', function() {
        const phoneNumber = testPhoneNumberInput.value.trim();
        const message = messageTemplate.value.trim();

        if (!phoneNumber || (!message && !selectedImageData)) {
            alert('Masukkan nomor telepon dan tulis pesan atau pilih gambar untuk test.');
            return;
        }

        sendTestBtn.disabled = true;
        sendTestBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Mengirim Test...';

        const formData = new FormData();
        formData.append('send_test', '1');
        formData.append('test_phone_number', phoneNumber);
        formData.append('message_template', message);
        if (selectedImageData) {
            formData.append('message_image', selectedImageData);
        }

        fetch('/pages/Whatsapp_blast.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(result => {
            if (result.status === 'success') {
                alert(result.message);
            } else {
                alert('Error: ' + result.message);
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Terjadi kesalahan jaringan. Coba lagi.');
        })
        .finally(() => {
            sendTestBtn.disabled = false;
            sendTestBtn.innerHTML = '<i class="fas fa-paper-plane mr-2"></i> Kirim Test';
        });
    });

    chooseImageBtn.addEventListener('click', () => imageInput.click());

    imageInput.addEventListener('change', function(event) {
        const file = event.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                selectedImageData = e.target.result;
                imagePreviewImg.src = selectedImageData;
                imagePreview.style.display = 'block';
                removeImageBtn.style.display = 'inline-block';
                updateSendButton();
            };
            reader.readAsDataURL(file);
        }
    });

    removeImageBtn.addEventListener('click', function() {
        selectedImageData = null;
        imageInput.value = '';
        imagePreview.style.display = 'none';
        removeImageBtn.style.display = 'none';
        updateSendButton();
    });

    function loadCustomers(search = '') {
        customerListContainer.innerHTML = '<p class="text-center text-gray-500 py-8"><i class="fas fa-spinner fa-spin mr-2"></i>Memuat data pelanggan...</p>';
        fetch(`/pages/Whatsapp_blast.php?get_customers=1&search=${encodeURIComponent(search)}`)
            .then(response => response.json())
            .then(customers => {
                allCustomers = customers;
                displayCustomers(customers);
            })
            .catch(error => {
                console.error('Error:', error);
                customerListContainer.innerHTML = '<p class="text-center text-red-500 py-8">Gagal memuat data. Coba lagi.</p>';
            });
    }

    function displayCustomers(customers) {
        if (customers.length === 0) {
            customerListContainer.innerHTML = '<p class="text-center text-gray-500 py-8">Tidak ada pelanggan yang ditemukan.</p>';
            sendBlastBtn.disabled = true;
            return;
        }
        let tableHTML = `
            <div class="mb-3">
                <label><input type="checkbox" id="selectAll"> <strong>Pilih Semua (${customers.length} pelanggan)</strong></label>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="text-left text-xs text-gray-500 uppercase tracking-wider border-b bg-gray-50">
                        <th><input type="checkbox" id="selectAllHeader"></th>
                        <th>Nama</th>
                        <th>No. Telepon</th>
                        <th>No. SPK</th>
                        <th>No. Invoice</th>
                    </thead>
                    <tbody class="text-sm">
        `;
        customers.forEach(cust => {
            // --- PERBARUI KEY UNTUK MENGAKSES DATA JSON ---
            tableHTML += `
                <tr class="border-b hover:bg-gray-50">
                    <td><input type="checkbox" class="recipient-checkbox" value="${cust['No Utama']}"></td>
                    <td>${cust['Nama Customer']}</td>
                    <td>${cust['No. Telepon']}</td>
                    <td>${cust['No. SPK']}</td>
                    <td>${cust['No. Invoice']}</td>
                </tr>
            `;
        });
        tableHTML += `</tbody></table></div>`;
        customerListContainer.innerHTML = tableHTML;

        const selectAllHeader = document.getElementById('selectAllHeader');
        const recipientCheckboxes = document.querySelectorAll('.recipient-checkbox');

        selectAllHeader.addEventListener('change', function() {
            recipientCheckboxes.forEach(cb => cb.checked = this.checked);
            updateSendButton();
        });

        recipientCheckboxes.forEach(cb => {
            cb.addEventListener('change', updateSendButton);
        });

        updateSendButton();
    }

    function updateSendButton() {
        const checkedBoxes = document.querySelectorAll('.recipient-checkbox:checked');
        const hasMessage = messageTemplate.value.trim() !== '' || selectedImageData !== null;
        sendBlastBtn.disabled = checkedBoxes.length === 0 || !hasMessage;
    }

    messageTemplate.addEventListener('input', updateSendButton);
    
    let searchTimeout;
    searchInput.addEventListener('input', function() {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(() => {
            loadCustomers(this.value);
        }, 500);
    });

    sendBlastBtn.addEventListener('click', function() {
        const checkedBoxes = document.querySelectorAll('.recipient-checkbox:checked');
        const recipients = Array.from(checkedBoxes).map(cb => cb.value);
        if (recipients.length === 0) {
            alert('Pilih setidaknya satu penerima.');
            return;
        }
        if (!confirm(`Apakah Anda yakin ingin mengirim pesan ke ${recipients.length} penerima?`)) {
            return;
        }
        sendBlastBtn.disabled = true;
        sendBlastBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Mengirim...';
        sendLogContainer.style.display = 'block';
        sendLog.innerHTML = '';

        const formData = new FormData();
        formData.append('send_message', '1');
        formData.append('message_template', messageTemplate.value);
        if (selectedImageData) {
            formData.append('message_image', selectedImageData);
        }
        recipients.forEach(id => formData.append('recipients[]', id));

        fetch('/pages/Whatsapp_blast.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(result => {
            if (result.status === 'completed') {
                let logHTML = `<p class="font-bold mb-2">Pengiriman Selesai. Sukses: ${result.success}, Gagal: ${result.failed}</p>`;
                result.log.forEach(log => {
                    const statusClass = log.status === 'Sukses' ? 'text-green-600' : 'text-red-600';
                    logHTML += `<p>${log.recipient}: <span class="${statusClass}">${log.status}</span> - ${log.message}</p>`;
                });
                sendLog.innerHTML = logHTML;
            } else {
                sendLog.innerHTML = `<p class="text-red-600 font-bold">Error: ${result.message}</p>`;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            sendLog.innerHTML = `<p class="text-red-600 font-bold">Terjadi kesalahan jaringan. Coba lagi.</p>`;
        })
        .finally(() => {
            sendBlastBtn.disabled = false;
            sendBlastBtn.innerHTML = '<i class="fas fa-paper-plane mr-2"></i> Kirim WhatsApp Blast';
            loadCustomers(searchInput.value);
        });
    });

    loadCustomers();
});
</script>

<?php require_once '../includes/footer.php'; ?>