<aside id="sidebar" class="w-64 sidebar-gradient text-white flex-shrink-0 transition-all duration-300 z-20 overflow-y-auto">
    <div class="p-6">
        <!-- Brand -->
        <div class="flex items-center space-x-3 mb-8">
            <div class="w-10 h-10 bg-white rounded-lg flex items-center justify-center">
                <i class="fa-solid fa-car text-suzuki-blue"></i>
            </div>
            <div>
                <span class="text-lg font-bold">Suzuki</span>
                <p class="text-xs opacity-80">Dashboard</p>
            </div>
        </div>

        <nav>
            <!-- Dashboard - Semua role bisa akses -->
            <div class="mb-6">
                <p class="text-xs text-gray-300 uppercase tracking-wider mb-3 px-3">Main Menu</p>
                
                <a href="/dashboard" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'dashboard' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-home w-5 mr-3"></i>
                    <span>Dashboard</span>
                </a>
                
                <!-- Menu untuk Service Advisor & Service Relation Officer & Service Manager -->
                <?php if ($_SESSION['role'] == 'Service Advisor' || $_SESSION['role'] == 'Service Relation Officer' || $_SESSION['role'] == 'Service Manager'): ?>
                <a href="/reminder" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'reminder' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-bell w-5 mr-3"></i>
                    <span>Reminder</span>
                    
                </a>
                <?php endif; ?>

                <!-- Menu untuk Customer Relation Officer & Service Manager -->
                <?php if ($_SESSION['role'] == 'Customer Relation Officer' || $_SESSION['role'] == 'Service Manager'): ?>
                <a href="/data-psf" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'data-psf' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-file-invoice w-5 mr-3"></i>
                    <span>Data PSF</span>
                </a>
                <?php endif; ?>
            </div>

                      <!-- Data Management - Hanya untuk Service Manager -->
            <?php if ($_SESSION['role'] == 'Service Manager'): ?>
            <div class="mb-6">
                <p class="text-xs text-gray-300 uppercase tracking-wider mb-3 px-3">Manage Data</p>
                
                <div class="menu-item flex items-center px-4 py-3 rounded-lg mb-1 cursor-pointer" onclick="toggleSubmenu('manageDataSubmenu')">
                    <i class="fa-solid fa-folder w-5 mr-3"></i>
                    <span class="flex-1">Manage Data</span>
                    <i class="fa-solid fa-chevron-right text-xs rotate-icon" id="manageDataSubmenuIcon"></i>
                </div>
                <div id="manageDataSubmenu" class="submenu ml-8">
                    <a href="/manage-user" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'manage-user' ? 'active' : ''; ?>">
                        <i class="fa-solid fa-user-shield w-4 mr-2"></i>  User
                    </a>
                    
                    <a href="/alasan_reminder" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'alasan_reminder' ? 'active' : ''; ?>">
                        <i class="fa-solid fa-file-contract w-4 mr-2"></i>  Reason
                    </a>
                </div>
            </div>
            <?php endif; ?>

            <!-- Tools - Hanya untuk Service Manager -->
            <?php if ($_SESSION['role'] == 'Service Manager'): ?>
            <div class="mb-6">
                <p class="text-xs text-gray-300 uppercase tracking-wider mb-3 px-3">Tools</p>
                
                <div class="menu-item flex items-center px-4 py-3 rounded-lg mb-1 cursor-pointer" onclick="toggleSubmenu('toolsSubmenu')">
                    <i class="fa-solid fa-tools w-5 mr-3"></i>
                    <span class="flex-1">Tools</span>
                    <i class="fa-solid fa-chevron-right text-xs rotate-icon" id="toolsSubmenuIcon"></i>
                </div>
                <div id="toolsSubmenu" class="submenu ml-8">
                    <a href="/backup" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white">
                        <i class="fa-solid fa-database w-4 mr-2"></i> Backup Data
                    </a>
                    
                    <a href="/upload-penjualan" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white">
                        <i class="fa-solid fa-file-import w-4 mr-2"></i> Import Data
                    </a>
                    <a href="/tools/logs" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white">
                        <i class="fa-solid fa-history w-4 mr-2"></i> System Logs
                    </a>
                </div>
            </div>
            <?php endif; ?>

            <!-- Reports & Analytics - Semua role bisa akses -->
            <div class="mb-6">
                <p class="text-xs text-gray-300 uppercase tracking-wider mb-3 px-3">Reports</p>
                <a href="/laporan" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'laporan' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-chart-bar w-5 mr-3"></i>
                    <span>Laporan</span>
                </a>
                <a href="/analytics" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'analytics' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-chart-line w-5 mr-3"></i>
                    <span>Analytics</span>
                </a>
            </div>

            <!-- Settings - Semua role bisa akses -->
            <div class="mb-6">
                <p class="text-xs text-gray-300 uppercase tracking-wider mb-3 px-3">Settings</p>
                <a href="/pengaturan" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'pengaturan' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-cog w-5 mr-3"></i>
                    <span>Pengaturan</span>
                </a>
                <a href="/akun" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'akun' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-user-cog w-5 mr-3"></i>
                    <span>Akun</span>
                </a>
                <a href="/keamanan" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'keamanan' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-key w-5 mr-3"></i>
                    <span>Keamanan</span>
                </a>
            </div>

            <!-- Profile Section - Semua role bisa akses -->
            <div class="mb-6">
                <p class="text-xs text-gray-300 uppercase tracking-wider mb-3 px-3">Profile</p>
                <div class="bg-white bg-opacity-10 rounded-lg p-3 mx-3">
                    <div class="flex items-center">
                        <img src="https://picsum.photos/seed/<?php echo $_SESSION['username']; ?>/40/40.jpg" alt="Profile" class="w-10 h-10 rounded-lg">
                        <div class="ml-3">
                            <p class="text-sm font-medium"><?php echo $_SESSION['name']; ?></p>
                            <p class="text-xs opacity-80"><?php echo $_SESSION['role']; ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </nav>
    </div>
</aside>

<script>
// 确保所有菜单项都能正确显示
document.addEventListener('DOMContentLoaded', function() {
    // 调试信息 - 可以在控制台查看当前用户角色
    console.log('Current user role:', '<?php echo $_SESSION['role']; ?>');
    
    // 检查会话变量是否设置
    <?php if (!isset($_SESSION['role'])): ?>
    console.error('User role is not set in session');
    <?php endif; ?>
    
    // 切换子菜单
    function toggleSubmenu(id) {
        const submenu = document.getElementById(id);
        submenu.classList.toggle('show');
        
        const icon = document.getElementById(id + 'Icon');
        icon.classList.toggle('rotated');
    }
    
    // 添加活动状态到当前页面
    const currentPath = window.location.pathname;
    const menuItems = document.querySelectorAll('.menu-item');
    
    menuItems.forEach(item => {
        const href = item.getAttribute('href');
        if (href && currentPath.includes(href)) {
            item.classList.add('active');
        }
    });
});
</script>