            </main>
            
            <!-- Footer -->
            <footer class="bg-white border-t border-gray-200 py-4 px-6">
                <div class="flex justify-between items-center">
                    <p class="text-sm text-gray-500">© 2023 Suzuki Dashboard</p>
                    <div class="flex items-center space-x-4">
                        <span class="flex items-center text-xs text-gray-500">
                            <span class="w-2 h-2 bg-green-500 rounded-full mr-2"></span>
                            System Online
                        </span>
                        <a href="#" class="text-sm text-gray-500 hover:text-suzuki-blue">Bantuan</a>
                        <a href="#" class="text-sm text-gray-500 hover:text-suzuki-blue">API</a>
                    </div>
                </div>
            </footer>
        </div>
    </div>
    
    <!-- Mobile Layout -->
    <div class="sm:hidden flex flex-col h-screen">
        <!-- Mobile Header -->
        <header class="mobile-header text-white p-4">
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    <button class="mr-3" onclick="toggleMobileSidebar()">
                        <i class="fas fa-bars text-xl"></i>
                    </button>
                    <div>
                        <h1 class="text-lg font-bold">Suzuki Dashboard</h1>
                        <p class="text-xs opacity-80"><?php echo isset($page_title) ? $page_title : 'Dashboard'; ?></p>
                    </div>
                </div>
                <div class="flex items-center space-x-3">
                    <button class="relative" onclick="toggleMobileNotifications()">
                        <i class="fas fa-bell text-lg"></i>
                        <span class="absolute -top-1 -right-1 w-2 h-2 bg-orange-400 rounded-full"></span>
                    </button>
                    <img src="https://picsum.photos/seed/<?php echo $_SESSION['username']; ?>/32/32.jpg" alt="Profile" class="w-8 h-8 rounded-lg">
                </div>
            </div>
        </header>
        
        <!-- Mobile Main Content -->
        <main class="flex-1 overflow-y-auto bg-gray-50 p-4 pb-20">
            <!-- Mobile content will be loaded here -->
        </main>
        
        <!-- Mobile Bottom Navigation -->
        <nav class="mobile-bottom-nav text-white px-4 py-2">
            <div class="flex justify-around">
                <button class="mobile-nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?> flex flex-col items-center py-2" onclick="setMobileNav(this, 'dashboard')">
                    <i class="fas fa-home text-lg mb-1"></i>
                    <span class="text-xs">Dashboard</span>
                </button>
                <button class="mobile-nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'reminder.php' ? 'active' : ''; ?> flex flex-col items-center py-2" onclick="setMobileNav(this, 'reminder')">
                    <i class="fas fa-bell text-lg mb-1"></i>
                    <span class="text-xs">Reminder</span>
                </button>
                <button class="mobile-nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'konsumen.php' ? 'active' : ''; ?> flex flex-col items-center py-2" onclick="setMobileNav(this, 'customers')">
                    <i class="fas fa-users text-lg mb-1"></i>
                    <span class="text-xs">Konsumen</span>
                </button>
                <button class="mobile-nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'kendaraan.php' ? 'active' : ''; ?> flex flex-col items-center py-2" onclick="setMobileNav(this, 'vehicles')">
                    <i class="fas fa-car text-lg mb-1"></i>
                    <span class="text-xs">Kendaraan</span>
                </button>
                <button class="mobile-nav-item <?php echo basename($_SERVER['PHP_SELF']) == 'pengaturan.php' ? 'active' : ''; ?> flex flex-col items-center py-2" onclick="setMobileNav(this, 'settings')">
                    <i class="fas fa-cog text-lg mb-1"></i>
                    <span class="text-xs">Pengaturan</span>
                </button>
            </div>
        </nav>
        
        <!-- Mobile Sidebar Overlay -->
        <div id="mobileOverlay" class="mobile-overlay fixed inset-0 z-40" onclick="toggleMobileSidebar()"></div>
        
        <!-- Mobile Sidebar -->
        <aside id="mobileSidebar" class="mobile-sidebar fixed left-0 top-0 h-full w-72 sidebar-gradient text-white z-50 overflow-y-auto">
            <div class="p-6">
                <div class="flex items-center justify-between mb-8">
                    <div class="flex items-center space-x-3">
                        <div class="w-10 h-10 bg-white rounded-lg flex items-center justify-center">
                            <i class="fas fa-car text-suzuki-blue"></i>
                        </div>
                        <div>
                            <span class="text-lg font-bold">Suzuki</span>
                            <p class="text-xs opacity-80">Dashboard</p>
                        </div>
                    </div>
                    <button onclick="toggleMobileSidebar()">
                        <i class="fas fa-times text-xl"></i>
                    </button>
                </div>
                
                <nav>
                    <!-- Main Navigation -->
                    <div class="mb-6">
                        <p class="text-xs text-gray-300 uppercase tracking-wider mb-3">Main Menu</p>
                        <a href="/pages/dashboard.php" class="menu-item <?php echo basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                            <i class="fas fa-home w-5 mr-3"></i>
                            <span>Dashboard</span>
                        </a>
                        <a href="/pages/reminder.php" class="menu-item <?php echo basename($_SERVER['PHP_SELF']) == 'reminder.php' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                            <i class="fas fa-bell w-5 mr-3"></i>
                            <span>Reminder</span>
                            <?php
                            // Count unread notifications
                            $sql = "SELECT COUNT(*) as count FROM notifications WHERE user_id = ? AND is_read = 0";
                            $stmt = $conn->prepare($sql);
                            $stmt->bind_param("i", $_SESSION['user_id']);
                            $stmt->execute();
                            $result = $stmt->get_result();
                            $row = $result->fetch_assoc();
                            $count = $row['count'];
                            
                            if ($count > 0) {
                                echo '<span class="ml-auto bg-orange-500 text-white text-xs rounded-full px-2 py-0.5">' . $count . '</span>';
                            }
                            ?>
                        </a>
                        <a href="/pages/konsumen.php" class="menu-item <?php echo basename($_SERVER['PHP_SELF']) == 'konsumen.php' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                            <i class="fas fa-users w-5 mr-3"></i>
                            <span>Konsumen</span>
                        </a>
                        <a href="/pages/kendaraan.php" class="menu-item <?php echo basename($_SERVER['PHP_SELF']) == 'kendaraan.php' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                            <i class="fas fa-car w-5 mr-3"></i>
                            <span>Kendaraan</span>
                        </a>
                    </div>
                    
                    <!-- Service Management -->
                    <div class="mb-6">
                        <p class="text-xs text-gray-300 uppercase tracking-wider mb-3">Service</p>
                        <div class="menu-item flex items-center px-4 py-3 rounded-lg mb-1 cursor-pointer" onclick="toggleSubmenu('mobileServiceSubmenu')">
                            <i class="fas fa-wrench w-5 mr-3"></i>
                            <span class="flex-1">Layanan</span>
                            <i class="fas fa-chevron-right text-xs rotate-icon" id="mobileServiceSubmenuIcon"></i>
                        </div>
                        <div id="mobileServiceSubmenu" class="submenu ml-8">
                            <a href="/pages/layanan.php?type=servis-berkala" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white">Servis Berkala</a>
                            <a href="/pages/layanan.php?type=body-repair" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white">Body Repair</a>
                            <a href="/pages/layanan.php?type=detailing" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white">Detailing</a>
                            <a href="/pages/layanan.php?type=ganti-oli" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white">Ganti Oli</a>
                        </div>
                    </div>
                    
                    <!-- Settings -->
                    <div class="mb-6">
                        <p class="text-xs text-gray-300 uppercase tracking-wider mb-3">Settings</p>
                        <a href="/pages/pengaturan.php" class="menu-item <?php echo basename($_SERVER['PHP_SELF']) == 'pengaturan.php' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                            <i class="fas fa-cog w-5 mr-3"></i>
                            <span>Pengaturan</span>
                        </a>
                        <a href="/pages/akun.php" class="menu-item <?php echo basename($_SERVER['PHP_SELF']) == 'akun.php' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                            <i class="fas fa-user-cog w-5 mr-3"></i>
                            <span>Akun</span>
                        </a>
                    </div>
                    
                    <!-- Profile Section - Integrated into Mobile Sidebar Flow -->
                    <div class="mb-6">
                        <p class="text-xs text-gray-300 uppercase tracking-wider mb-3">Profile</p>
                        <div class="bg-white bg-opacity-10 rounded-lg p-3 mx-3">
                            <div class="flex items-center">
                                <img src="https://picsum.photos/seed/<?php echo $_SESSION['username']; ?>/40/40.jpg" alt="Profile" class="w-10 h-10 rounded-lg">
                                <div class="ml-3">
                                    <p class="text-sm font-medium"><?php echo $_SESSION['name']; ?></p>
                                    <p class="text-xs opacity-80"><?php echo $_SESSION['email']; ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </nav>
            </div>
        </aside>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <script src="/assets/js/script.js"></script>
</body>
</html>