<?php
// Set header untuk menunjukkan bahwa respons adalah JSON
header('Content-Type: application/json');

// Matikan error reporting agar output JSON tidak terganggu (opsional, namun disarankan untuk produksi)
error_reporting(0);

// Include file konfigurasi database
// Sesuaikan path jika lokasi config.php Anda berbeda
require_once '../includes/config.php'; 

// Inisialisasi array respons
 $response = [
    'success' => false,
    'message' => '',
    'data' => null
];

// Periksa apakah parameter 'no' ada dan valid (numerik)
if (isset($_GET['no']) && is_numeric($_GET['no'])) {
    
    // Sanitasi input dengan casting ke integer
    $no = (int)$_GET['no'];

    // Persiapkan query untuk mengambil data berdasarkan 'No'
    // Menggunakan SELECT * untuk mengambil semua kolom
    $sql = "SELECT * FROM penjualan WHERE No = ?";
    
    $stmt = $conn->prepare($sql);

    if ($stmt) {
        // Bind parameter 'no' ke statement (tipe 'i' untuk integer)
        $stmt->bind_param("i", $no);
        
        // Eksekusi query
        if ($stmt->execute()) {
            // Dapatkan hasil
            $result = $stmt->get_result();
            
            // Periksa apakah ada data yang ditemukan
            if ($result && $result->num_rows > 0) {
                // Ambil data sebagai array asosiatif
                $data = $result->fetch_assoc();
                
                // Set respons sukses
                $response['success'] = true;
                $response['message'] = 'Data berhasil ditemukan.';
                $response['data'] = $data;
            } else {
                // Set respons jika data tidak ditemukan
                $response['message'] = 'Data tidak ditemukan untuk nomor tersebut.';
            }
        } else {
            // Set respons jika eksekusi query gagal
            $response['message'] = 'Gagal mengeksekusi query.';
        }
        
        // Tutup statement
        $stmt->close();
    } else {
        // Set respons jika persiapan statement gagal
        $response['message'] = 'Terjadi kesalahan pada database.';
    }
    
} else {
    // Set respons jika parameter 'no' tidak ada atau tidak valid
    $response['message'] = "Parameter 'no' tidak valid atau tidak disertakan.";
}

// Tutup koneksi database
 $conn->close();

// Encode array respons menjadi JSON dan tampilkan
echo json_encode($response);
?>