<?php
$filename = "contoh_penjualan.tsv";

header("Content-Type: text/tab-separated-values; charset=UTF-8");
header("Content-Disposition: attachment; filename=\"$filename\"");

// Buka output stream
$out = fopen("php://output", "w");

// Tulis BOM (supaya UTF-8 normal di Excel)
fprintf($out, chr(0xEF).chr(0xBB).chr(0xBF));

// Header TAB (SAMA PERSIS seperti contoh kamu)
$header = [
    "No",
    "Tanggal Masuk",
    "Tanggal Finish SPK",
    "No. SPK",
    "No. Invoice",
    "No. Invoice Claim",
    "Nama Customer",
    "NPWP",
    "No. Telepon",
    "Nama Pemilik",
    "Alamat Pemilik",
    "KM",
    "No. Polisi",
    "Type",
    "Model",
    "Transmisi",
    "Kategori",
    "Tahun",
    "No. Buku Service",
    "Warna",
    "Kategori Service",
    "No. Rangka",
    "No. Mesin",
    "Service Advisor",
    "Teknisi",
    "Foreman",
    "Kategori.1",
    "Jasa",
    "Oli",
    "Part",
    "OPL",
    "Sublet",
    "Discon",
    "HPP",
    "Total DPP",
    "Total DPP + PPN",
    "Pembayaran",
    "Status",
    "Keluhan",
    "Lokasi Service",
    "Status Promo",
    "Rekomendasi"
];

// Tulis header sebagai TSV (TAB-separated)
fwrite($out, implode("\t", $header) . "\n");

// Baris kosong template
$empty = array_fill(0, count($header), "");
fwrite($out, implode("\t", $empty) . "\n");

fclose($out);
exit;
