<?php
 $page_title = "Reminder Konsumen";
 $page_subtitle = "Kelola reminder konsumen";

require_once '../includes/header.php';

// Get filter parameters
 $type = isset($_GET['type']) ? sanitize_input($_GET['type']) : '';
 $status = isset($_GET['status']) ? sanitize_input($_GET['status']) : '';
 $search = isset($_GET['search']) ? sanitize_input($_GET['search']) : '';

// Build query
 $sql = "SELECT r.id, r.type, r.status, r.due_date, r.description, c.name as customer_name, c.vehicle_model, c.phone 
        FROM reminders r 
        JOIN customers c ON r.customer_id = c.id 
        WHERE 1=1";

 $params = [];
 $types = "";

if (!empty($type)) {
    $sql .= " AND r.type = ?";
    $params[] = $type;
    $types .= "s";
}

if (!empty($status)) {
    $sql .= " AND r.status = ?";
    $params[] = $status;
    $types .= "s";
}

if (!empty($search)) {
    $sql .= " AND (c.name LIKE ? OR c.vehicle_model LIKE ? OR r.description LIKE ?)";
    $searchParam = "%$search%";
    $params[] = $searchParam;
    $params[] = $searchParam;
    $params[] = $searchParam;
    $types .= "sss";
}

 $sql .= " ORDER BY r.due_date ASC";

// Prepare and execute query
 $stmt = $conn->prepare($sql);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
 $stmt->execute();
 $result = $stmt->get_result();

// Get reminder types for filter
 $typesResult = $conn->query("SELECT DISTINCT type FROM reminders ORDER BY type");
 $types = [];
if ($typesResult->num_rows > 0) {
    while ($row = $typesResult->fetch_assoc()) {
        $types[] = $row['type'];
    }
}

// Get status options
 $statusOptions = ['pending', 'completed', 'important'];
?>
<!-- Filter Section -->
<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Filter Reminder</h2>
        <button class="btn-primary px-3 py-1 text-white rounded-lg text-sm mt-2 md:mt-0" onclick="addNewReminder()">
            <i class="fas fa-plus mr-1"></i> Tambah Reminder
        </button>
    </div>
    
    <form method="GET" action="/pages/reminder.php" class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Tipe</label>
            <select name="type" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                <option value="">Semua Tipe</option>
                <?php foreach ($types as $t): ?>
                <option value="<?php echo $t; ?>" <?php echo ($type == $t) ? 'selected' : ''; ?>><?php echo ucfirst($t); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
            <select name="status" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                <option value="">Semua Status</option>
                <?php foreach ($statusOptions as $s): ?>
                <option value="<?php echo $s; ?>" <?php echo ($status == $s) ? 'selected' : ''; ?>><?php echo ucfirst($s); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Pencarian</label>
            <input type="text" name="search" value="<?php echo $search; ?>" placeholder="Nama, model, atau deskripsi" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
        </div>
        
        <div class="flex items-end">
            <button type="submit" class="w-full btn-primary px-4 py-2 text-white rounded-lg">
                <i class="fas fa-search mr-2"></i> Cari
            </button>
        </div>
    </form>
</div>

<!-- Reminders Table -->
<div class="glass-card rounded-xl p-6 fade-in">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Daftar Reminder</h2>
<div class="text-sm text-gray-500">
Menampilkan <?php echo $result->num_rows; ?> data
</div>
</div>

<div class="overflow-x-auto">
<table class="w-full">
<thead>
<tr class="text-left text-xs text-gray-500 uppercase tracking-wider border-b">
<th class="pb-3">Konsumen</th>
<th class="pb-3">Kendaraan</th>
<th class="pb-3">Tipe</th>
<th class="pb-3">Deskripsi</th>
<th class="pb-3">Tanggal</th>
<th class="pb-3">Status</th>
<th class="pb-3">Aksi</th>
</tr>
</thead>
<tbody class="text-sm">
<?php if ($result->num_rows > 0): ?>
<?php while ($row = $result->fetch_assoc()): ?>
<tr class="table-row border-b">
<td class="py-3">
<div class="flex items-center">
<img src="https://picsum.photos/seed/<?php echo $row['customer_name']; ?>/32/32.jpg" alt="User" class="w-8 h-8 rounded-lg mr-2">
<div>
<p class="font-medium text-gray-800"><?php echo $row['customer_name']; ?></p>
<p class="text-xs text-gray-500"><?php echo $row['phone']; ?></p>
</div>
</div>
</td>
<td class="py-3">
<p class="font-medium text-gray-800"><?php echo $row['vehicle_model']; ?></p>
</td>
<td class="py-3">
<?php
$badgeClass = '';
$badgeText = '';

switch ($row['type']) {
case 'servis':
$badgeClass = 'bg-blue-100 text-blue-700';
$badgeText = 'Servis';
break;
case 'asuransi':
$badgeClass = 'bg-orange-100 text-orange-700';
$badgeText = 'Asuransi';
break;
case 'stnk':
$badgeClass = 'bg-green-100 text-green-700';
$badgeText = 'STNK';
break;
}
?>
<span class="badge px-2 py-1 text-xs rounded-full <?php echo $badgeClass; ?>"><?php echo $badgeText; ?></span>
</td>
<td class="py-3">
<p class="text-gray-800"><?php echo $row['description']; ?></p>
</td>
<td class="py-3">
<p class="text-gray-800"><?php echo date('d M Y', strtotime($row['due_date'])); ?></p>
</td>
<td class="py-3">
<?php
$statusClass = '';
$statusText = '';

switch ($row['status']) {
case 'pending':
$statusClass = 'bg-yellow-100 text-yellow-700';
$statusText = 'Menunggu';
break;
case 'completed':
$statusClass = 'bg-green-100 text-green-700';
$statusText = 'Selesai';
break;
case 'important':
$statusClass = 'bg-orange-100 text-orange-700';
$statusText = 'Penting';
break;
}
?>
<span class="badge px-2 py-1 text-xs rounded-full <?php echo $statusClass; ?>"><?php echo $statusText; ?></span>
</td>
<td class="py-3">
<div class="flex space-x-2">
<button class="text-suzuki-blue hover:text-suzuki-dark" onclick="viewReminder(<?php echo $row['id']; ?>)">
<i class="fas fa-eye"></i>
</button>
<button class="text-green-600 hover:text-green-800" onclick="editReminder(<?php echo $row['id']; ?>)">
<i class="fas fa-edit"></i>
</button>
<button class="text-red-600 hover:text-red-800" onclick="deleteReminder(<?php echo $row['id']; ?>)">
<i class="fas fa-trash"></i>
</button>
</div>
</td>
</tr>
<?php endwhile; ?>
<?php else: ?>
<tr>
<td colspan="7" class="py-8 text-center text-gray-500">
<i class="fas fa-inbox text-4xl mb-2"></i>
<p>Tidak ada data reminder</p>
</td>
</tr>
<?php endif; ?>
</tbody>
</table>
</div></div>

<?php require_once '../includes/footer.php'; ?>