<?php
 $page_title = "Keamanan";
 $page_subtitle = "Kelola pengaturan keamanan akun";

require_once '../includes/header.php';

// Get user security settings
 $sql = "SELECT * FROM user_security WHERE user_id = ?";
 $stmt = $conn->prepare($sql);
 $stmt->bind_param("i", $_SESSION['user_id']);
 $stmt->execute();
 $result = $stmt->get_result();

 $securitySettings = null;
if ($result->num_rows > 0) {
    $securitySettings = $result->fetch_assoc();
}

// Get login history
 $sql = "SELECT * FROM login_history WHERE user_id = ? ORDER BY login_time DESC LIMIT 10";
 $stmt = $conn->prepare($sql);
 $stmt->bind_param("i", $_SESSION['user_id']);
 $stmt->execute();
 $result = $stmt->get_result();

 $loginHistory = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $loginHistory[] = $row;
    }
}

// Process form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $twoFactorEnabled = isset($_POST['two_factor_enabled']) ? 1 : 0;
    $emailNotifications = isset($_POST['email_notifications']) ? 1 : 0;
    $sessionTimeout = sanitize_input($_POST['session_timeout']);
    
    if ($securitySettings) {
        // Update existing security settings
        $sql = "UPDATE user_security SET two_factor_enabled = ?, email_notifications = ?, session_timeout = ? WHERE user_id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("iiii", $twoFactorEnabled, $emailNotifications, $sessionTimeout, $_SESSION['user_id']);
    } else {
        // Insert new security settings
        $sql = "INSERT INTO user_security (user_id, two_factor_enabled, email_notifications, session_timeout) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("iiii", $_SESSION['user_id'], $twoFactorEnabled, $emailNotifications, $sessionTimeout);
    }
    
    $stmt->execute();
    
    $successMessage = "Pengaturan keamanan berhasil diperbarui";
    
    // Refresh security settings
    $sql = "SELECT * FROM user_security WHERE user_id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $securitySettings = $result->fetch_assoc();
    }
}
?>
<!-- Security Settings -->
<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold text-gray-800">Pengaturan Keamanan</h2>
    </div>
    
    <?php if (isset($successMessage)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-6" role="alert">
            <span class="block sm:inline"><?php echo $successMessage; ?></span>
        </div>
    <?php endif; ?>
    
    <form method="POST" action="/pages/keamanan.php">
        <div class="space-y-4 mb-6">
            <div class="flex items-center justify-between p-4 border border-gray-200 rounded-lg">
                <div>
                    <h3 class="font-medium text-gray-800">Autentikasi Dua Faktor</h3>
                    <p class="text-sm text-gray-500">Tambahkan lapisan keamanan ekstra ke akun Anda</p>
                </div>
                <div class="flex items-center">
                    <label class="relative inline-flex items-center cursor-pointer">
                        <input type="checkbox" name="two_factor_enabled" class="sr-only peer" <?php echo ($securitySettings && $securitySettings['two_factor_enabled']) ? 'checked' : ''; ?>>
                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-suzuki-blue rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-suzuki-blue"></div>
                    </label>
                </div>
            </div>
            
            <div class="flex items-center justify-between p-4 border border-gray-200 rounded-lg">
                <div>
                    <h3 class="font-medium text-gray-800">Notifikasi Email</h3>
                    <p class="text-sm text-gray-500">Terima notifikasi tentang aktivitas akun Anda</p>
                </div>
                <div class="flex items-center">
                    <label class="relative inline-flex items-center cursor-pointer">
                        <input type="checkbox" name="email_notifications" class="sr-only peer" <?php echo ($securitySettings && $securitySettings['email_notifications']) ? 'checked' : ''; ?>>
                        <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-suzuki-blue rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-suzuki-blue"></div>
                    </label>
                </div>
            </div>
            
            <div class="p-4 border border-gray-200 rounded-lg">
                <h3 class="font-medium text-gray-800 mb-3">Timeout Sesi</h3>
                <p class="text-sm text-gray-500 mb-3">Durasi sebelum sesi otomatis berakhir</p>
                <select name="session_timeout" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                    <option value="1800" <?php echo ($securitySettings && $securitySettings['session_timeout'] == 1800) ? 'selected' : ''; ?>>30 menit</option>
                    <option value="3600" <?php echo ($securitySettings && $securitySettings['session_timeout'] == 3600) ? 'selected' : ''; ?>>1 jam</option>
                    <option value="7200" <?php echo ($securitySettings && $securitySettings['session_timeout'] == 7200) ? 'selected' : ''; ?>>2 jam</option>
                    <option value="14400" <?php echo ($securitySettings && $securitySettings['session_timeout'] == 14400) ? 'selected' : ''; ?>>4 jam</option>
                    <option value="28800" <?php echo ($securitySettings && $securitySettings['session_timeout'] == 28800) ? 'selected' : ''; ?>>8 jam</option>
                </select>
            </div>
        </div>
        
        <div class="flex justify-end">
            <button type="submit" class="btn-primary px-6 py-2 text-white rounded-lg">
                <i class="fas fa-shield-alt mr-2"></i> Simpan Pengaturan
            </button>
        </div>
    </form>
</div>

<!-- Login History -->
<div class="glass-card rounded-xl p-6 fade-in">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold text-gray-800">Riwayat Login</h2>
    </div>
    
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead>
                <tr class="text-left text-xs text-gray-500 uppercase tracking-wider border-b">
                    <th class="pb-3">Waktu</th>
                    <th class="pb-3">IP Address</th>
                    <th class="pb-3">Perangkat</th>
                    <th class="pb-3">Browser</th>
                    <th class="pb-3">Lokasi</th>
                    <th class="pb-3">Status</th>
                </tr>
            </thead>
            <tbody class="text-sm">
                <?php if (count($loginHistory) > 0): ?>
                    <?php foreach ($loginHistory as $login): ?>
                    <tr class="table-row border-b">
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo date('d M Y H:i', strtotime($login['login_time'])); ?></p>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo $login['ip_address']; ?></p>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo $login['device']; ?></p>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo $login['browser']; ?></p>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo $login['location']; ?></p>
                        </td>
                        <td class="py-3">
                            <?php
                            $statusClass = '';
                            $statusText = '';
                            
                            if ($login['status'] == 'success') {
                                $statusClass = 'bg-green-100 text-green-700';
                                $statusText = 'Berhasil';
                            } else {
                                $statusClass = 'bg-red-100 text-red-700';
                                $statusText = 'Gagal';
                            }
                            ?>
                            <span class="badge px-2 py-1 text-xs rounded-full <?php echo $statusClass; ?>"><?php echo $statusText; ?></span>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" class="py-8 text-center text-gray-500">
                            <i class="fas fa-history text-4xl mb-2"></i>
                            <p>Belum ada riwayat login</p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>