<?php
 $page_title = "Dokumen";
 $page_subtitle = "Kelola dokumen kendaraan konsumen";

require_once '../includes/header.php';

// Get document type from URL parameter
 $docType = isset($_GET['type']) ? sanitize_input($_GET['type']) : 'stnk';

// Set page title based on document type
switch ($docType) {
    case 'stnk':
        $page_title = "STNK";
        $page_subtitle = "Kelola dokumen STNK kendaraan";
        break;
    case 'asuransi':
        $page_title = "Asuransi";
        $page_subtitle = "Kelola dokumen asuransi kendaraan";
        break;
    case 'bpkb':
        $page_title = "BPKB";
        $page_subtitle = "Kelola dokumen BPKB kendaraan";
        break;
    case 'faktur':
        $page_title = "Faktur";
        $page_subtitle = "Kelola dokumen faktur pembelian";
        break;
}

// Get filter parameters
 $search = isset($_GET['search']) ? sanitize_input($_GET['search']) : '';
 $status = isset($_GET['status']) ? sanitize_input($_GET['status']) : '';

// Build query
 $sql = "SELECT d.*, c.name as customer_name, v.model, v.license_plate 
        FROM documents d 
        JOIN customers c ON d.customer_id = c.id 
        JOIN vehicles v ON d.vehicle_id = v.id 
        WHERE d.type = ?";

 $params = [$docType];
 $types = "s";

if (!empty($search)) {
    $sql .= " AND (c.name LIKE ? OR v.model LIKE ? OR v.license_plate LIKE ? OR d.document_number LIKE ?)";
    $searchParam = "%$search%";
    $params[] = $searchParam;
    $params[] = $searchParam;
    $params[] = $searchParam;
    $params[] = $searchParam;
    $types .= "ssss";
}

if (!empty($status)) {
    $sql .= " AND d.status = ?";
    $params[] = $status;
    $types .= "s";
}

 $sql .= " ORDER BY d.expiry_date ASC";

// Prepare and execute query
 $stmt = $conn->prepare($sql);
 $stmt->bind_param($types, ...$params);
 $stmt->execute();
 $result = $stmt->get_result();

// Get status options
 $statusOptions = ['active', 'expired', 'renewed'];
?>
<!-- Filter Section -->
<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Filter <?php echo $page_title; ?></h2>
        <button class="btn-primary px-3 py-1 text-white rounded-lg text-sm mt-2 md:mt-0" onclick="addNewDocument()">
            <i class="fas fa-plus mr-1"></i> Tambah Dokumen
        </button>
    </div>
    
    <form method="GET" action="/pages/dokumen.php" class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <input type="hidden" name="type" value="<?php echo $docType; ?>">
        
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Pencarian</label>
            <input type="text" name="search" value="<?php echo $search; ?>" placeholder="Nama, model, plat nomor, atau nomor dokumen" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
        </div>
        
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
            <select name="status" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                <option value="">Semua Status</option>
                <?php foreach ($statusOptions as $s): ?>
                <option value="<?php echo $s; ?>" <?php echo ($status == $s) ? 'selected' : ''; ?>><?php echo ucfirst($s); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div class="flex items-end">
            <button type="submit" class="w-full btn-primary px-4 py-2 text-white rounded-lg">
                <i class="fas fa-search mr-2"></i> Cari
            </button>
        </div>
    </form>
</div>

<!-- Documents Table -->
<div class="glass-card rounded-xl p-6 fade-in">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Daftar <?php echo $page_title; ?></h2>
        <div class="text-sm text-gray-500">
            Menampilkan <?php echo $result->num_rows; ?> data
        </div>
    </div>
    
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead>
                <tr class="text-left text-xs text-gray-500 uppercase tracking-wider border-b">
                    <th class="pb-3">Konsumen</th>
                    <th class="pb-3">Kendaraan</th>
                    <th class="pb-3">Nomor Dokumen</th>
                    <th class="pb-3">Tanggal Terbit</th>
                    <th class="pb-3">Tanggal Kadaluarsa</th>
                    <th class="pb-3">Status</th>
                    <th class="pb-3">Aksi</th>
                </tr>
            </thead>
            <tbody class="text-sm">
                <?php if ($result->num_rows > 0): ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                    <tr class="table-row border-b">
                        <td class="py-3">
                            <div class="flex items-center">
                                <img src="https://picsum.photos/seed/<?php echo $row['customer_name']; ?>/32/32.jpg" alt="User" class="w-8 h-8 rounded-lg mr-2">
                                <div>
                                    <p class="font-medium text-gray-800"><?php echo $row['customer_name']; ?></p>
                                </div>
                            </div>
                        </td>
                        <td class="py-3">
                            <p class="font-medium text-gray-800"><?php echo $row['model']; ?></p>
                            <p class="text-xs text-gray-500"><?php echo $row['license_plate']; ?></p>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo $row['document_number']; ?></p>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo date('d M Y', strtotime($row['issue_date'])); ?></p>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo date('d M Y', strtotime($row['expiry_date'])); ?></p>
                        </td>
                        <td class="py-3">
                            <?php
                            $statusClass = '';
                            $statusText = '';
                            
                            switch ($row['status']) {
                                case 'active':
                                    $statusClass = 'bg-green-100 text-green-700';
                                    $statusText = 'Aktif';
                                    break;
                                case 'expired':
                                    $statusClass = 'bg-red-100 text-red-700';
                                    $statusText = 'Kadaluarsa';
                                    break;
                                case 'renewed':
                                    $statusClass = 'bg-blue-100 text-blue-700';
                                    $statusText = 'Diperbarui';
                                    break;
                            }
                            ?>
                            <span class="badge px-2 py-1 text-xs rounded-full <?php echo $statusClass; ?>"><?php echo $statusText; ?></span>
                        </td>
                        <td class="py-3">
                            <div class="flex space-x-2">
                                <button class="text-suzuki-blue hover:text-suzuki-dark" onclick="viewDocument(<?php echo $row['id']; ?>)">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <button class="text-green-600 hover:text-green-800" onclick="editDocument(<?php echo $row['id']; ?>)">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="text-red-600 hover:text-red-800" onclick="deleteDocument(<?php echo $row['id']; ?>)">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" class="py-8 text-center text-gray-500">
                            <i class="fas fa-file-alt text-4xl mb-2"></i>
                            <p>Tidak ada data dokumen</p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>