<?php
 $page_title = "Akun";
 $page_subtitle = "Kelola informasi akun Anda";

require_once '../includes/header.php';

// Get current user information
 $sql = "SELECT * FROM users WHERE id = ?";
 $stmt = $conn->prepare($sql);
 $stmt->bind_param("i", $_SESSION['user_id']);
 $stmt->execute();
 $result = $stmt->get_result();

 $user = null;
if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();
}

// Process form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $name = sanitize_input($_POST['name']);
    $email = sanitize_input($_POST['email']);
    $phone = sanitize_input($_POST['phone']);
    
    // Check if email is already used by another user
    $sql = "SELECT id FROM users WHERE email = ? AND id != ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("si", $email, $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $errorMessage = "Email sudah digunakan oleh pengguna lain";
    } else {
        // Update user information
        $sql = "UPDATE users SET name = ?, email = ?, phone = ? WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssi", $name, $email, $phone, $_SESSION['user_id']);
        $stmt->execute();
        
        // Update session
        $_SESSION['name'] = $name;
        $_SESSION['email'] = $email;
        
        $successMessage = "Informasi akun berhasil diperbarui";
        
        // Refresh user data
        $sql = "SELECT * FROM users WHERE id = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $_SESSION['user_id']);
        $stmt->execute();
        $result = $stmt->get_result();
        
        if ($result->num_rows > 0) {
            $user = $result->fetch_assoc();
        }
    }
}

// Process password change
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['change_password'])) {
    $currentPassword = $_POST['current_password'];
    $newPassword = $_POST['new_password'];
    $confirmPassword = $_POST['confirm_password'];
    
    // Verify current password
    if (password_verify($currentPassword, $user['password'])) {
        if ($newPassword === $confirmPassword) {
            if (strlen($newPassword) >= 8) {
                // Update password
                $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);
                $sql = "UPDATE users SET password = ? WHERE id = ?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("si", $hashedPassword, $_SESSION['user_id']);
                $stmt->execute();
                
                $passwordSuccessMessage = "Password berhasil diperbarui";
            } else {
                $passwordErrorMessage = "Password minimal 8 karakter";
            }
        } else {
            $passwordErrorMessage = "Password baru dan konfirmasi tidak cocok";
        }
    } else {
        $passwordErrorMessage = "Password saat ini salah";
    }
}
?>
<!-- Account Information -->
<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold text-gray-800">Informasi Akun</h2>
    </div>
    
    <?php if (isset($successMessage)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-6" role="alert">
            <span class="block sm:inline"><?php echo $successMessage; ?></span>
        </div>
    <?php endif; ?>
    
    <?php if (isset($errorMessage)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-6" role="alert">
            <span class="block sm:inline"><?php echo $errorMessage; ?></span>
        </div>
    <?php endif; ?>
    
    <form method="POST" action="/pages/akun.php">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
            <div>
                <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Nama Lengkap</label>
                <input type="text" id="name" name="name" value="<?php echo $user['name']; ?>" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
            </div>
            
            <div>
                <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                <input type="email" id="email" name="email" value="<?php echo $user['email']; ?>" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
            </div>
            
            <div>
                <label for="username" class="block text-sm font-medium text-gray-700 mb-1">Username</label>
                <input type="text" id="username" name="username" value="<?php echo $user['username']; ?>" disabled class="w-full px-3 py-2 border border-gray-300 rounded-lg bg-gray-100">
                <p class="text-xs text-gray-500 mt-1">Username tidak dapat diubah</p>
            </div>
            
            <div>
                <label for="phone" class="block text-sm font-medium text-gray-700 mb-1">Telepon</label>
                <input type="text" id="phone" name="phone" value="<?php echo $user['phone']; ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
            </div>
        </div>
        
        <div class="flex justify-end">
            <button type="submit" class="btn-primary px-6 py-2 text-white rounded-lg">
                <i class="fas fa-save mr-2"></i> Simpan Perubahan
            </button>
        </div>
    </form>
</div>

<!-- Change Password -->
<div class="glass-card rounded-xl p-6 fade-in">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold text-gray-800">Ubah Password</h2>
    </div>
    
    <?php if (isset($passwordSuccessMessage)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-6" role="alert">
            <span class="block sm:inline"><?php echo $passwordSuccessMessage; ?></span>
        </div>
    <?php endif; ?>
    
    <?php if (isset($passwordErrorMessage)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-6" role="alert">
            <span class="block sm:inline"><?php echo $passwordErrorMessage; ?></span>
        </div>
    <?php endif; ?>
    
    <form method="POST" action="/pages/akun.php">
        <input type="hidden" name="change_password" value="1">
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
            <div>
                <label for="current_password" class="block text-sm font-medium text-gray-700 mb-1">Password Saat Ini</label>
                <input type="password" id="current_password" name="current_password" required class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
            </div>
            
            <div>
                <label for="new_password" class="block text-sm font-medium text-gray-700 mb-1">Password Baru</label>
                <input type="password" id="new_password" name="new_password" required minlength="8" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                <p class="text-xs text-gray-500 mt-1">Minimal 8 karakter</p>
            </div>
            
            <div class="md:col-span-2">
                <label for="confirm_password" class="block text-sm font-medium text-gray-700 mb-1">Konfirmasi Password Baru</label>
                <input type="password" id="confirm_password" name="confirm_password" required minlength="8" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
            </div>
        </div>
        
        <div class="flex justify-end">
            <button type="submit" class="btn-primary px-6 py-2 text-white rounded-lg">
                <i class="fas fa-key mr-2"></i> Ubah Password
            </button>
        </div>
    </form>
</div>

<?php require_once '../includes/footer.php'; ?>