<aside id="sidebar" class="w-64 sidebar-gradient text-white flex-shrink-0 transition-all duration-300 z-20 overflow-y-auto">
    <div class="p-6">
        <!-- Brand -->
        <div class="flex items-center space-x-3 mb-8">
            <div class="w-10 h-10 bg-white rounded-lg flex items-center justify-center">
                <i class="fa-solid fa-car text-suzuki-blue"></i>
            </div>
            <div>
                <span class="text-lg font-bold">Suzuki</span>
                <p class="text-xs opacity-80">Dashboard</p>
            </div>
        </div>

        <nav>
            <!-- Main Menu -->
            <div class="mb-6">
                <p class="text-xs text-gray-300 uppercase tracking-wider mb-3 px-3">Main Menu</p>
                
                <a href="/dashboard" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'dashboard' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-home w-5 mr-3"></i>
                    <span>Dashboard</span>
                </a>
                
                <a href="/reminder" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'reminder' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-bell w-5 mr-3"></i>
                    <span>Reminder</span>
                    <?php
                    $sql = "SELECT COUNT(*) as count FROM notifications WHERE user_id = ? AND is_read = 0";
                    $stmt = $conn->prepare($sql);
                    $stmt->bind_param("i", $_SESSION['user_id']);
                    $stmt->execute();
                    $result = $stmt->get_result();
                    $row = $result->fetch_assoc();
                    $count = $row['count'];
                    if ($count > 0) {
                        echo '<span class="ml-auto bg-orange-500 text-white text-xs rounded-full px-2 py-0.5 notification-dot">' . $count . '</span>';
                    }
                    ?>
                </a>

                <a href="/konsumen" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'konsumen' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-users w-5 mr-3"></i>
                    <span>Konsumen</span>
                </a>

                <a href="/kendaraan" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'kendaraan' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-car w-5 mr-3"></i>
                    <span>Kendaraan</span>
                </a>
            </div>

            <!-- Service Management -->
            <div class="mb-6">
                <p class="text-xs text-gray-300 uppercase tracking-wider mb-3 px-3">Service</p>
                <div class="menu-item flex items-center px-4 py-3 rounded-lg mb-1 cursor-pointer" onclick="toggleSubmenu('serviceSubmenu')">
                    <i class="fa-solid fa-wrench w-5 mr-3"></i>
                    <span class="flex-1">Layanan</span>
                    <i class="fa-solid fa-chevron-right text-xs rotate-icon" id="serviceSubmenuIcon"></i>
                </div>
                <div id="serviceSubmenu" class="submenu ml-8">
                    <a href="/layanan?type=servis-berkala" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white">
                        <i class="fa-solid fa-oil-can w-4 mr-2"></i> Servis Berkala
                    </a>
                    <a href="/layanan?type=body-repair" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white">
                        <i class="fa-solid fa-car-crash w-4 mr-2"></i> Body Repair
                    </a>
                    <a href="/layanan?type=detailing" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white">
                        <i class="fa-solid fa-spray-can w-4 mr-2"></i> Detailing
                    </a>
                    <a href="/layanan?type=ganti-oli" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white">
                        <i class="fa-solid fa-battery-full w-4 mr-2"></i> Ganti Oli
                    </a>
                </div>
            </div>

            <!-- Document Management -->
            <div class="mb-6">
                <p class="text-xs text-gray-300 uppercase tracking-wider mb-3 px-3">Documents</p>
                <div class="menu-item flex items-center px-4 py-3 rounded-lg mb-1 cursor-pointer" onclick="toggleSubmenu('documentSubmenu')">
                    <i class="fa-solid fa-file-alt w-5 mr-3"></i>
                    <span class="flex-1">Dokumen</span>
                    <i class="fa-solid fa-chevron-right text-xs rotate-icon" id="documentSubmenuIcon"></i>
                </div>
                <div id="documentSubmenu" class="submenu ml-8">
                    <a href="/dokumen?type=stnk" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white">
                        <i class="fa-solid fa-id-card w-4 mr-2"></i> STNK
                    </a>
                    <a href="/dokumen?type=asuransi" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white">
                        <i class="fa-solid fa-shield-alt w-4 mr-2"></i> Asuransi
                    </a>
                    <a href="/dokumen?type=bpkb" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white">
                        <i class="fa-solid fa-file-contract w-4 mr-2"></i> BPKB
                    </a>
                    <a href="/dokumen?type=faktur" class="submenu-item block px-4 py-2 rounded text-sm text-gray-300 hover:text-white">
                        <i class="fa-solid fa-receipt w-4 mr-2"></i> Faktur
                    </a>
                </div>
            </div>

            <!-- Reports & Analytics -->
            <div class="mb-6">
                <p class="text-xs text-gray-300 uppercase tracking-wider mb-3 px-3">Reports</p>
                <a href="/laporan" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'laporan' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-chart-bar w-5 mr-3"></i>
                    <span>Laporan</span>
                </a>
                <a href="/analytics" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'analytics' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-chart-line w-5 mr-3"></i>
                    <span>Analytics</span>
                </a>
                <a href="/jadwal-service" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'jadwal-service' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-calendar-alt w-5 mr-3"></i>
                    <span>Jadwal Service</span>
                </a>
            </div>

            <!-- Settings -->
            <div class="mb-6">
                <p class="text-xs text-gray-300 uppercase tracking-wider mb-3 px-3">Settings</p>
                <a href="/pengaturan" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'pengaturan' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-cog w-5 mr-3"></i>
                    <span>Pengaturan</span>
                </a>
                <a href="/akun" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'akun' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-user-cog w-5 mr-3"></i>
                    <span>Akun</span>
                </a>
                <a href="/keamanan" class="menu-item <?php echo basename($_SERVER['PHP_SELF'], '.php') == 'keamanan' ? 'active' : ''; ?> flex items-center px-4 py-3 rounded-lg mb-1">
                    <i class="fa-solid fa-key w-5 mr-3"></i>
                    <span>Keamanan</span>
                </a>
            </div>

            <!-- Profile Section -->
            <div class="mb-6">
                <p class="text-xs text-gray-300 uppercase tracking-wider mb-3 px-3">Profile</p>
                <div class="bg-white bg-opacity-10 rounded-lg p-3 mx-3">
                    <div class="flex items-center">
                        <img src="https://picsum.photos/seed/<?php echo $_SESSION['username']; ?>/40/40.jpg" alt="Profile" class="w-10 h-10 rounded-lg">
                        <div class="ml-3">
                            <p class="text-sm font-medium"><?php echo $_SESSION['name']; ?></p>
                            <p class="text-xs opacity-80"><?php echo $_SESSION['email']; ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </nav>
    </div>
</aside>
