<?php
session_start();
require_once '../config/database.php';
require_login();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Suzuki Dashboard - <?php echo isset($page_title) ? $page_title : 'Dashboard'; ?></title>

    <!-- Tailwind CSS -->
       <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Custom CSS -->
    <link rel="stylesheet" href="../assets/css/style.css">

    <style>
        /* Extra CSS kecil untuk notifikasi dan toggle icon */
        .notification-dot {
            display: inline-block;
            width: 0.5rem;
            height: 0.5rem;
            border-radius: 9999px;
        }
        .rotate-icon {
            transition: transform 0.2s;
        }
        .rotate-90 {
            transform: rotate(90deg);
        }
    </style>
</head>
<body>
    <!-- Desktop & Tablet Layout -->
    <div class="hidden sm:flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <?php include 'sidebar.php'; ?>
        
        <!-- Main Content -->
        <div class="flex-1 flex flex-col overflow-hidden">
            <!-- Header -->
            <header class="bg-white shadow-sm z-10">
                <div class="flex items-center justify-between px-6 py-4">
                    <div>
                        <h1 class="text-2xl font-semibold text-gray-800">
                            <?php echo isset($page_title) ? $page_title : 'Dashboard'; ?>
                        </h1>
                        <p class="text-sm text-gray-500">
                            <?php echo isset($page_subtitle) ? $page_subtitle : 'Suzuki Dashboard'; ?>
                        </p>
                    </div>
                    
                    <div class="flex items-center space-x-4">
                        <!-- Search Input -->
                        <div class="relative hidden md:block">
                            <input type="text" placeholder="Cari data..." class="search-input pl-10 pr-4 py-2 border border-gray-200 rounded-lg focus:outline-none w-64" onkeyup="handleSearch(this.value)">
                            <i class="fa-solid fa-magnifying-glass absolute left-3 top-3 text-gray-400"></i>
                        </div>
                        
                        <!-- Notification Dropdown -->
                        <div class="relative">
                            <button class="relative p-2 text-gray-600 hover:text-suzuki-blue transition" onclick="toggleNotifications()">
                                <i class="fa-solid fa-bell text-lg"></i>
                                <span class="absolute top-1 right-1 w-2 h-2 bg-orange-500 rounded-full"></span>
                            </button>
                            
                            <div id="notificationDropdown" class="absolute right-0 mt-2 w-80 bg-white rounded-lg shadow-xl hidden z-50">
                                <div class="p-4 border-b border-gray-100 flex items-center justify-between">
                                    <h3 class="font-semibold text-gray-800">Notifikasi</h3>
                                    <span class="text-xs text-gray-500">
                                        <?php
                                        $sql = "SELECT COUNT(*) as count FROM notifications WHERE user_id = ? AND is_read = 0";
                                        $stmt = $conn->prepare($sql);
                                        $stmt->bind_param("i", $_SESSION['user_id']);
                                        $stmt->execute();
                                        $result = $stmt->get_result();
                                        $row = $result->fetch_assoc();
                                        echo $row['count'] . ' baru';
                                        ?>
                                    </span>
                                </div>
                                <div class="max-h-96 overflow-y-auto">
                                    <?php
                                    $sql = "SELECT * FROM notifications WHERE user_id = ? AND is_read = 0 ORDER BY created_at DESC LIMIT 5";
                                    $stmt = $conn->prepare($sql);
                                    $stmt->bind_param("i", $_SESSION['user_id']);
                                    $stmt->execute();
                                    $result = $stmt->get_result();

                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            echo '<div class="notification-item p-4 border-b border-gray-50 cursor-pointer" onclick="viewNotification(' . $row['id'] . ')">
                                                <div class="flex items-start">
                                                    <div class="w-10 h-10 bg-'.$row['color'].'-100 rounded-full flex items-center justify-center mr-3 flex-shrink-0">
                                                        <i class="fa-solid fa-'.$row['icon'].' text-'.$row['color'].'-600 text-sm"></i>
                                                    </div>
                                                    <div class="flex-1">
                                                        <p class="text-sm font-medium text-gray-800">'.$row['title'].'</p>
                                                        <p class="text-xs text-gray-500 mt-1">'.$row['message'].'</p>
                                                        <p class="text-xs text-gray-400 mt-2">'.time_elapsed_string($row['created_at']).'</p>
                                                    </div>
                                                </div>
                                            </div>';
                                        }
                                    } else {
                                        echo '<div class="p-4 text-center text-gray-500">Tidak ada notifikasi baru</div>';
                                    }
                                    ?>
                                </div>
                                <div class="p-3 border-t border-gray-100">
                                    <a href="/pages/reminder.php" class="w-full text-center text-sm text-suzuki-blue hover:text-suzuki-dark font-medium block">
                                        Lihat Semua Notifikasi
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Profile Dropdown -->
                        <div class="relative">
                            <button class="flex items-center text-gray-700 focus:outline-none" onclick="toggleProfileMenu()">
                                <img src="https://picsum.photos/seed/<?php echo $_SESSION['username']; ?>/32/32.jpg" alt="Profile" class="w-8 h-8 rounded-lg">
                                <i class="fa-solid fa-chevron-down ml-2 text-xs"></i>
                            </button>
                            
                            <div id="profileMenu" class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-lg py-2 hidden z-50">
                                <a href="/pages/akun.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Profil</a>
                                <a href="/pages/pengaturan.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Pengaturan</a>
                                <hr class="my-2">
                                <a href="/auth/logout.php" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Keluar</a>
                            </div>
                        </div>
                    </div>
                </div>
            </header>

<script>
    // Toggle notifikasi
    function toggleNotifications() {
        document.getElementById('notificationDropdown').classList.toggle('hidden');
    }
    // Toggle profile menu
    function toggleProfileMenu() {
        document.getElementById('profileMenu').classList.toggle('hidden');
    }
</script>
