<?php
session_start();
require_once '../config/database.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = sanitize_input($_POST['username']);
    $password = $_POST['password'];
    
    // Check user credentials
    $sql = "SELECT id, username, name, email, password FROM users WHERE username = ? OR email = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $username, $username);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        
        // Verify password
        if (password_verify($password, $row['password'])) {
            // Set session variables
            $_SESSION['user_id'] = $row['id'];
            $_SESSION['username'] = $row['username'];
            $_SESSION['name'] = $row['name'];
            $_SESSION['email'] = $row['email'];
            
            // Return success response
            echo json_encode(['success' => true, 'message' => 'Login berhasil']);
        } else {
            // Return error response
            echo json_encode(['success' => false, 'message' => 'Password salah']);
        }
    } else {
        // Return error response
        echo json_encode(['success' => false, 'message' => 'Username atau email tidak ditemukan']);
    }
} else {
    // Return error response
    echo json_encode(['success' => false, 'message' => 'Metode request tidak valid']);
}
?>