// Initialize Chart
const ctx = document.getElementById('reminderChart');
if (ctx) {
    const reminderChart = new Chart(ctx.getContext('2d'), {
        type: 'line',
        data: {
            labels: ['Sen', 'Sel', 'Rab', 'Kam', 'Jum', 'Sab', 'Min'],
            datasets: [{
                label: 'Servis',
                data: [12, 19, 8, 15, 22, 18, 25],
                borderColor: '#0033a0',
                backgroundColor: 'rgba(0, 51, 160, 0.1)',
                tension: 0.4,
                fill: true
            }, {
                label: 'Asuransi',
                data: [5, 8, 12, 7, 9, 14, 11],
                borderColor: '#ff6600',
                backgroundColor: 'rgba(255, 102, 0, 0.1)',
                tension: 0.4,
                fill: true
            }, {
                label: 'STNK',
                data: [15, 12, 18, 20, 14, 16, 22],
                borderColor: '#10b981',
                backgroundColor: 'rgba(16, 185, 129, 0.1)',
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        usePointStyle: true,
                        padding: 15
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)'
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });
}

// Functional JavaScript
function setActiveMenu(element) {
    document.querySelectorAll('.menu-item').forEach(item => {
        item.classList.remove('active');
    });
    element.classList.add('active');
}

function toggleSubmenu(submenuId) {
    const submenu = document.getElementById(submenuId);
    const icon = document.getElementById(submenuId + 'Icon');
    submenu.classList.toggle('open');
    icon.classList.toggle('open');
}

function toggleProfileMenu() {
    const menu = document.getElementById('profileMenu');
    menu.classList.toggle('hidden');
}

function toggleNotifications() {
    const dropdown = document.getElementById('notificationDropdown');
    dropdown.classList.toggle('hidden');
}

function viewNotification(id) {
    // Mark notification as read
    fetch('/api/mark_notification_read.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({ notification_id: id })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            // Update UI
            const notificationElement = document.querySelector(`[onclick="viewNotification(${id})"]`);
            if (notificationElement) {
                notificationElement.style.opacity = '0.7';
            }
        }
    })
    .catch(error => console.error('Error:', error));
    
    toggleNotifications();
}

function handleSearch(value) {
    if (value.length > 2) {
        // Implement search functionality here
        console.log('Searching for:', value);
    }
}

function changePeriod(period) {
    console.log('Period changed to:', period);
    // Update data based on period
    updateProgressData(period);
}

function updateChart(days) {
    console.log('Chart updated for', days, 'days');
    // Update chart data based on selected days
}

function updateProgressData(period) {
    // Simulate updating progress data
    const progressBar = document.querySelector('.progress-fill');
    const progressText = document.querySelector('.flex.justify-between.text-sm.mb-2 span:last-child');
    
    if (progressBar && progressText) {
        if (period === 'week') {
            progressBar.style.width = '78%';
            progressText.textContent = '156/200 (78%)';
        } else if (period === 'month') {
            progressBar.style.width = '65%';
            progressText.textContent = '520/800 (65%)';
        } else if (period === 'year') {
            progressBar.style.width = '82%';
            progressText.textContent = '6560/8000 (82%)';
        }
    }
}

function viewReminder(id) {
    console.log('Viewing reminder:', id);
    // Redirect to reminder detail page
    window.location.href = '/pages/reminder_detail.php?id=' + id;
}

function addNewReminder() {
    console.log('Adding new reminder');
    // Redirect to add reminder page
    window.location.href = '/pages/add_reminder.php';
}

// Mobile functions
function toggleMobileSidebar() {
    const sidebar = document.getElementById('mobileSidebar');
    const overlay = document.getElementById('mobileOverlay');
    sidebar.classList.toggle('open');
    overlay.classList.toggle('show');
}

function toggleMobileNotifications() {
    alert('Mobile notifications:\n• Servis Berkala - Swift GX\n• Asuransi Expired\n• Perpanjangan STNK\n• Jadwal Service\n• Penting - Overdue');
}

function setMobileNav(element, page) {
    document.querySelectorAll('.mobile-nav-item').forEach(item => {
        item.classList.remove('active');
    });
    element.classList.add('active');
    
    // Redirect to the selected page
    switch(page) {
        case 'dashboard':
            window.location.href = '/pages/dashboard.php';
            break;
        case 'reminder':
            window.location.href = '/pages/reminder.php';
            break;
        case 'customers':
            window.location.href = '/pages/konsumen.php';
            break;
        case 'vehicles':
            window.location.href = '/pages/kendaraan.php';
            break;
        case 'settings':
            window.location.href = '/pages/pengaturan.php';
            break;
    }
}

// Close dropdowns when clicking outside
document.addEventListener('click', function(event) {
    const profileMenu = document.getElementById('profileMenu');
    const notificationDropdown = document.getElementById('notificationDropdown');
    const profileButton = event.target.closest('button[onclick="toggleProfileMenu()"]');
    const notificationButton = event.target.closest('button[onclick="toggleNotifications()"]');
    
    if (!profileButton && !profileMenu.contains(event.target)) {
        profileMenu.classList.add('hidden');
    }
    
    if (!notificationButton && !notificationDropdown.contains(event.target)) {
        notificationDropdown.classList.add('hidden');
    }
});

// Simulate real-time updates
setInterval(() => {
    const stats = document.querySelectorAll('.text-2xl.font-bold, .mobile-text-xl');
    // Randomly update a stat
    const randomStat = stats[Math.floor(Math.random() * stats.length)];
    const currentValue = parseInt(randomStat.textContent);
    const change = Math.random() > 0.5 ? 1 : -1;
    const newValue = Math.max(0, currentValue + change);
    randomStat.textContent = newValue;
}, 5000);

// Helper function to format time elapsed
function time_elapsed_string($datetime) {
    // This function should be implemented in PHP, but here's a JS version for reference
    const time = Date.parse(datetime);
    const now = new Date();
    const seconds = Math.floor((now - time) / 1000);
    
    let interval = Math.floor(seconds / 31536000);
    if (interval > 1) return interval + " tahun yang lalu";
    
    interval = Math.floor(seconds / 2592000);
    if (interval > 1) return interval + " bulan yang lalu";
    
    interval = Math.floor(seconds / 86400);
    if (interval > 1) return interval + " hari yang lalu";
    
    interval = Math.floor(seconds / 3600);
    if (interval > 1) return interval + " jam yang lalu";
    
    interval = Math.floor(seconds / 60);
    if (interval > 1) return interval + " menit yang lalu";
    
    return "Baru saja";
}