<?php
 $page_title = "Upload Data Penjualan";
 $page_subtitle = "Impor data penjualan dari file CSV dengan mudah dan aman";

require_once '../includes/header.php';

// Inisialisasi variabel untuk pesan
 $uploadMessage = '';
 $isSuccess = false;
 $importedCount = 0;

// Proses jika form disubmit
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csv_file'])) {
    
    // --- Validasi File ---
    if ($_FILES['csv_file']['error'] !== UPLOAD_ERR_OK) {
        $uploadMessage = "Error saat mengunggah file. Kode error: " . $_FILES['csv_file']['error'];
    } else {
        $fileName = basename($_FILES['csv_file']['name']);
        $fileType = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

        if ($fileType != 'csv') {
            $uploadMessage = "Hanya file CSV yang diperbolehkan.";
        } else {
            // --- Proses Baca CSV dan Import ke Database ---
            $filePath = $_FILES['csv_file']['tmp_name'];
            
            if (($handle = fopen($filePath, 'r')) !== FALSE) {
                fgetcsv($handle, 1000, ","); // Lewati header

                // --- PERBAIKAN DINAMIS: Ambil nama kolom dari tabel ---
                $columns = [];
                $result_cols = $conn->query("SHOW COLUMNS FROM penjualan");
                while ($row = $result_cols->fetch_assoc()) {
                    // Kecualikan kolom 'No' karena AUTO_INCREMENT
                    if ($row['Field'] !== 'No') {
                        $columns[] = "`" . $row['Field'] . "`";
                    }
                }
                $column_list = implode(', ', $columns);
                $placeholder_count = count($columns);
                $placeholder_list = implode(', ', array_fill(0, $placeholder_count, '?'));
                
                // Siapkan prepared statement secara dinamis
                $sql = "INSERT INTO penjualan ($column_list) VALUES ($placeholder_list)";
                $stmt = $conn->prepare($sql);

                while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                    // --- Deteksi dan hapus kolom 'No' dari CSV jika ada ---
                    if (count($data) == 48) {
                        array_shift($data);
                    }

                    if (count($data) == $placeholder_count) {
                        $data = array_map(function($value) { return ($value === '') ? null : $value; }, $data);
                        $types = str_repeat('s', $placeholder_count);
                        $stmt->bind_param($types, ...$data);
                        
                        if ($stmt->execute()) {
                            $importedCount++;
                        }
                    }
                }

                fclose($handle);
                $stmt->close();

                // Tentukan status upload
                $status = ($importedCount > 0) ? 'success' : 'failed';

                // Simpan ke riwayat upload
                $historySql = "INSERT INTO upload_history (filename, records_imported, status) VALUES (?, ?, ?)";
                $historyStmt = $conn->prepare($historySql);
                $historyStmt->bind_param("sis", $fileName, $importedCount, $status);
                $historyStmt->execute();
                $historyStmt->close();

                if ($importedCount > 0) {
                    $uploadMessage = "Berhasil! <strong>{$importedCount}</strong> data penjualan berhasil diimpor.";
                    $isSuccess = true;
                } else {
                    $uploadMessage = "Tidak ada data yang diimpor. Pastikan file CSV tidak kosong dan formatnya benar.";
                }
            } else {
                $uploadMessage = "Gagal membuka file CSV.";
            }
        }
    }
}

// Ambil 10 riwayat upload terbaru
 $historyQuery = "SELECT id, filename, upload_time, records_imported, status FROM upload_history ORDER BY upload_time DESC LIMIT 10";
 $historyResult = $conn->query($historyQuery);
?>

<!-- Kontainer Utama (FULL WIDTH) -->
<div class="w-full px-4 sm:px-6 lg:px-8 py-8">
    <div class="bg-gradient-to-br from-blue-50 to-indigo-100 rounded-2xl shadow-xl p-8 md:p-12">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 lg:gap-12 items-start">
            
            <!-- Kolom Kiri: Panduan -->
            <div class="bg-white rounded-2xl shadow-lg p-8 flex flex-col h-full">
                <div class="flex items-center mb-6">
                    <div class="flex-shrink-0 bg-blue-100 rounded-full p-3 mr-4">
                        <i class="fas fa-info-circle text-2xl text-blue-600"></i>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-gray-800">Panduan Upload</h2>
                        <p class="text-sm text-gray-500">Ikuti langkah-langkah berikut</p>
                    </div>
                </div>

                <div class="space-y-4 text-gray-700 text-sm flex-grow">
                    <div class="flex items-start">
                        <span class="flex-shrink-0 w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-xs mr-3 mt-0.5">1</span>
                        <p><strong>Unduh Template:</strong> Gunakan template CSV yang telah kami sediakan untuk memastikan format data benar.</p>
                    </div>
                    <div class="flex items-start">
                        <span class="flex-shrink-0 w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-xs mr-3 mt-0.5">2</span>
                        <p><strong>Isi Data:</strong> Lengkapi data penjualan Anda pada file tersebut. Jangan ubah nama kolom di baris pertama.</p>
                    </div>
                    <div class="flex items-start">
                        <span class="flex-shrink-0 w-6 h-6 bg-blue-600 text-white rounded-full flex items-center justify-center text-xs mr-3 mt-0.5">3</span>
                        <p><strong>Upload File:</strong> Pilih file CSV yang sudah Anda isi di kolom sebelah kanan.</p>
                    </div>
                </div>

                <div class="mt-8">
                    <a href="/uploads/penjualan_template.csv" download class="w-full inline-flex items-center justify-center px-6 py-3 bg-green-500 hover:bg-green-600 text-white font-semibold rounded-lg shadow-md transition duration-150 ease-in-out transform hover:scale-105">
                        <i class="fas fa-file-download mr-3"></i> Unduh Template CSV
                    </a>
                </div>
            </div>

            <!-- Kolom Kanan: Form Upload -->
            <div class="bg-white rounded-2xl shadow-lg p-8 flex flex-col">
                <div class="flex items-center mb-6">
                    <div class="flex-shrink-0 bg-green-100 rounded-full p-3 mr-4">
                        <i class="fas fa-cloud-upload-alt text-2xl text-green-600"></i>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-gray-800">Upload File</h2>
                        <p class="text-sm text-gray-500">Pilih file CSV Anda di sini</p>
                    </div>
                </div>
                
                <form method="POST" enctype="multipart/form-data" class="flex flex-col flex-grow">
                    <div class="flex-grow border-2 border-dashed border-gray-300 rounded-xl p-8 text-center hover:border-blue-600 transition-colors duration-300 flex items-center justify-center">
                        <div>
                            <i class="fas fa-file-csv text-5xl text-gray-400 mb-4"></i>
                            <label for="csv_file" class="cursor-pointer">
                                <span class="text-lg font-medium text-gray-700">Klik untuk memilih file</span>
                                <p class="text-sm text-gray-500 mt-1">atau drag and drop</p>
                                <input type="file" name="csv_file" id="csv_file" accept=".csv" required class="hidden">
                                <p class="text-xs text-gray-400 mt-4">Format yang didukung: .csv (Maks. 10MB)</p>
                            </label>
                            <p id="file-name" class="text-sm text-blue-600 font-medium mt-4"></p>
                        </div>
                    </div>
                    
                    <!-- TOMBOL YANG DIPERBAIKI -->
                    <button type="submit" class="w-full mt-6 px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white font-semibold rounded-lg shadow-md transition duration-150 ease-in-out transform hover:scale-105">
                        <i class="fas fa-file-import mr-2"></i> Impor Data Sekarang
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Pesan Hasil -->
<?php if (!empty($uploadMessage)): ?>
    <div class="w-full px-4 sm:px-6 lg:px-8 mt-6">
        <div class="p-4 rounded-lg shadow-lg flex items-center <?php echo $isSuccess ? 'bg-green-100 text-green-700' : 'bg-red-100 text-red-700'; ?>">
            <i class="fas <?php echo $isSuccess ? 'fa-check-circle' : 'fa-exclamation-circle'; ?> text-2xl mr-3"></i>
            <p><?php echo $uploadMessage; ?></p>
        </div>
    </div>
<?php endif; ?>

<!-- Tabel Riwayat Upload -->
<div class="w-full px-4 sm:px-6 lg:px-8 mt-8">
    <div class="glass-card rounded-xl p-6 fade-in">
        <div class="flex items-center justify-between mb-4">
            <h2 class="text-lg font-semibold text-gray-800">
                <i class="fas fa-history mr-2 text-blue-600"></i>Riwayat 10 Upload Terbaru
            </h2>
        </div>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead>
                    <tr class="text-left text-xs text-gray-500 uppercase tracking-wider border-b">
                        <th class="pb-3">No</th>
                        <th class="pb-3">Nama File</th>
                        <th class="pb-3">Tanggal & Waktu Upload</th>
                        <th class="pb-3">Jumlah Data Diimpor</th>
                        <th class="pb-3">Status</th>
                    </tr>
                </thead>
                <tbody class="text-sm">
                    <?php if ($historyResult && $historyResult->num_rows > 0): ?>
                        <?php $no = 1; while ($row = $historyResult->fetch_assoc()): ?>
                            <tr class="table-row border-b">
                                <td class="py-3"><?php echo $no++; ?></td>
                                <td class="py-3"><?php echo htmlspecialchars($row['filename']); ?></td>
                                <td class="py-3"><?php echo date('d M Y, H:i:s', strtotime($row['upload_time'])); ?></td>
                                <td class="py-3"><?php echo $row['records_imported']; ?></td>
                                <td class="py-3">
                                    <?php
                                    $statusClass = '';
                                    $statusText = '';
                                    switch ($row['status']) {
                                        case 'success':
                                            $statusClass = 'bg-green-100 text-green-700';
                                            $statusText = 'Berhasil';
                                            break;
                                        case 'failed':
                                            $statusClass = 'bg-red-100 text-red-700';
                                            $statusText = 'Gagal';
                                            break;
                                        case 'partial':
                                            $statusClass = 'bg-yellow-100 text-yellow-700';
                                            $statusText = 'Sebagian';
                                            break;
                                        default:
                                            $statusClass = 'bg-gray-100 text-gray-700';
                                            $statusText = 'Unknown';
                                    }
                                    ?>
                                    <span class="badge px-2 py-1 text-xs rounded-full <?php echo $statusClass; ?>"><?php echo $statusText; ?></span>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="5" class="text-center py-8 text-gray-500">
                                <i class="fas fa-inbox text-4xl mb-2"></i>
                                <p>Belum ada riwayat upload.</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    // Script untuk menampilkan nama file yang dipilih
    document.getElementById('csv_file').addEventListener('change', function(e) {
        const fileName = e.target.files[0]?.name;
        const fileNameSpan = document.getElementById('file-name');
        if (fileName) {
            fileNameSpan.textContent = `File yang dipilih: ${fileName}`;
        } else {
            fileNameSpan.textContent = '';
        }
    });
</script>

<?php require_once '../includes/footer.php'; ?>