<?php
// --- TIGA BARIS INI ADALAH SOLUSI UNTUK MASALAH CACHE ---
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

 $page_title = "Laporan Reminder";
 $page_subtitle = "Laporan data reminder pelanggan";

require_once '../includes/header.php';

// Get filter parameters
 $filter_date_from = $_GET['filter_date_from'] ?? date('Y-m-01');
 $filter_date_to = $_GET['filter_date_to'] ?? date('Y-m-d');
 $filter_contactable = $_GET['filter_contactable'] ?? 'all';
 $filter_reason = $_GET['filter_reason'] ?? 'all';
 $filter_search = $_GET['filter_search'] ?? '';

// Build WHERE clause (digunakan untuk semua query)
 $where_conditions = [];
 $params = [];
 $types = '';

if (!empty($filter_date_from)) {
    $where_conditions[] = "DATE(created_at) >= ?";
    $params[] = $filter_date_from;
    $types .= 's';
}

if (!empty($filter_date_to)) {
    $where_conditions[] = "DATE(created_at) <= ?";
    $params[] = $filter_date_to;
    $types .= 's';
}

if ($filter_contactable !== 'all') {
    $where_conditions[] = "contactable = ?";
    $params[] = $filter_contactable;
    $types .= 's';
}

if ($filter_reason !== 'all') {
    $where_conditions[] = "reason = ?";
    $params[] = $filter_reason;
    $types .= 's';
}

if (!empty($filter_search)) {
    $where_conditions[] = "(police_number LIKE ? OR customer_name LIKE ? OR vin_number LIKE ? OR no_mesin LIKE ?)";
    $searchParam = "%$filter_search%";
    for($i=0; $i<4; $i++) {
        $params[] = $searchParam;
        $types .= 's';
    }
}

 $where_clause = !empty($where_conditions) ? 'WHERE ' . implode(' AND ', $where_conditions) : '';

// --- SOLUSI DEFINITIF: Satu query untuk semua statistik ---
 $sql_stats = "
    SELECT 
        COUNT(DISTINCT id) as total_reminders,
        SUM(CASE WHEN contactable = 'yes' THEN 1 ELSE 0 END) as contactable_yes,
        SUM(CASE WHEN contactable = 'no' THEN 1 ELSE 0 END) as contactable_no,
        SUM(CASE WHEN booking_date_time IS NOT NULL AND booking_date_time != '' THEN 1 ELSE 0 END) as booking_count
    FROM reminders 
    $where_clause
";

 $stmt_stats = $conn->prepare($sql_stats);
if (!empty($params)) {
    $stmt_stats->bind_param($types, ...$params);
}
 $stmt_stats->execute();
 $result_stats = $stmt_stats->get_result();
 $statistics = $result_stats->fetch_assoc();

// Assign variables from the single result
 $total_reminders = $statistics['total_reminders'];
 $contactable_yes = $statistics['contactable_yes'];
 $contactable_no = $statistics['contactable_no'];
 $booking_count = $statistics['booking_count'];


// Get reminder data untuk ditampilkan di tabel
 $sql_table = "SELECT DISTINCT * FROM reminders $where_clause ORDER BY created_at DESC";
 $stmt_table = $conn->prepare($sql_table);
if (!empty($params)) {
    $stmt_table->bind_param($types, ...$params);
}
 $stmt_table->execute();
 $result_table = $stmt_table->get_result();

 $reminders_data = [];
if ($result_table && $result_table->num_rows > 0) {
    $reminders_data = $result_table->fetch_all(MYSQLI_ASSOC);
}

// Get unique reasons for filter dropdown
 $reasons_sql = "SELECT DISTINCT reason FROM reminders ORDER BY reason";
 $reasons_result = $conn->query($reasons_sql);
 $reasons_list = [];
if ($reasons_result) {
    while ($row = $reasons_result->fetch_assoc()) {
        $reasons_list[] = $row['reason'];
    }
}
?>
<!-- Filter Section -->
<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Filter Laporan</h2>
        <div class="flex space-x-2 mt-2 md:mt-0">
            <button onclick="exportToExcel()" class="px-4 py-2 bg-green-600 hover:bg-green-700 text-white font-medium rounded-lg shadow-md transition-all">
                <i class="fas fa-file-excel mr-2"></i> Export Excel
            </button>
            <button onclick="window.print()" class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg shadow-md transition-all">
                <i class="fas fa-print mr-2"></i> Cetak
            </button>
        </div>
    </div>
    
    <form id="filterForm" action="/report_reminder" method="GET" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Dari Tanggal</label>
            <input type="date" name="filter_date_from" value="<?php echo htmlspecialchars($filter_date_from); ?>" 
                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-600">
        </div>
        
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Sampai Tanggal</label>
            <input type="date" name="filter_date_to" value="<?php echo htmlspecialchars($filter_date_to); ?>" 
                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-600">
        </div>
        
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Status Kontak</label>
            <select name="filter_contactable" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-600">
                <option value="all" <?php echo $filter_contactable === 'all' ? 'selected' : ''; ?>>Semua</option>
                <option value="yes" <?php echo $filter_contactable === 'yes' ? 'selected' : ''; ?>>Bisa Dihubungi</option>
                <option value="no" <?php echo $filter_contactable === 'no' ? 'selected' : ''; ?>>Tidak Bisa Dihubungi</option>
            </select>
        </div>
        
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Alasan</label>
            <select name="filter_reason" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-600">
                <option value="all" <?php echo $filter_reason === 'all' ? 'selected' : ''; ?>>Semua</option>
                <?php foreach ($reasons_list as $reason): ?>
                    <option value="<?php echo htmlspecialchars($reason); ?>" <?php echo $filter_reason === $reason ? 'selected' : ''; ?>>
                        <?php echo htmlspecialchars($reason); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div class="lg:col-span-3">
            <label class="block text-sm font-medium text-gray-700 mb-1">Pencarian (No. Polisi, Nama, VIN, No. Mesin)</label>
            <input type="text" name="filter_search" value="<?php echo htmlspecialchars($filter_search); ?>" 
                   placeholder="Masukkan kata kunci pencarian..." 
                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-600">
        </div>
        
        <div class="flex items-end">
            <button type="submit" class="w-full px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-semibold rounded-lg shadow-md transition duration-150 ease-in-out">
                <i class="fas fa-filter mr-2"></i> Filter
            </button>
        </div>
    </form>
</div>

<!-- Statistics Cards -->
<div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-6">
    <div class="bg-gradient-to-r from-blue-50 to-blue-100 p-4 rounded-lg shadow-sm border border-blue-200">
        <div class="flex items-center">
            <div class="p-3 bg-blue-500 rounded-lg mr-3">
                <i class="fas fa-bell text-white text-xl"></i>
            </div>
            <div>
                <p class="text-xs text-gray-600">Total Reminder</p>
                <p class="text-2xl font-bold text-gray-800"><?php echo number_format($total_reminders, 0, ',', '.'); ?></p>
            </div>
        </div>
    </div>
    
    <div class="bg-gradient-to-r from-green-50 to-green-100 p-4 rounded-lg shadow-sm border border-green-200">
        <div class="flex items-center">
            <div class="p-3 bg-green-500 rounded-lg mr-3">
                <i class="fas fa-phone text-white text-xl"></i>
            </div>
            <div>
                <p class="text-xs text-gray-600">Bisa Dihubungi</p>
                <p class="text-2xl font-bold text-gray-800"><?php echo number_format($contactable_yes, 0, ',', '.'); ?></p>
            </div>
        </div>
    </div>
    
    <div class="bg-gradient-to-r from-red-50 to-red-100 p-4 rounded-lg shadow-sm border border-red-200">
        <div class="flex items-center">
            <div class="p-3 bg-red-500 rounded-lg mr-3">
                <i class="fas fa-phone-slash text-white text-xl"></i>
            </div>
            <div>
                <p class="text-xs text-gray-600">Tidak Bisa Dihubungi</p>
                <p class="text-2xl font-bold text-gray-800"><?php echo number_format($contactable_no, 0, ',', '.'); ?></p>
            </div>
        </div>
    </div>
    
    <div class="bg-gradient-to-r from-purple-50 to-purple-100 p-4 rounded-lg shadow-sm border border-purple-200">
        <div class="flex items-center">
            <div class="p-3 bg-purple-500 rounded-lg mr-3">
                <i class="fas fa-calendar-check text-white text-xl"></i>
            </div>
            <div>
                <p class="text-xs text-gray-600">Booking</p>
                <p class="text-2xl font-bold text-gray-800"><?php echo number_format($booking_count, 0, ',', '.'); ?></p>
            </div>
        </div>
    </div>
</div>

<!-- Report Table -->
<div class="glass-card rounded-xl p-6 fade-in">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Laporan Reminder</h2>
        <div class="text-sm text-gray-500">
            Menampilkan <?php echo count($reminders_data); ?> data
            <?php if (!empty($filter_date_from) || !empty($filter_date_to)): ?>
                (<?php echo !empty($filter_date_from) ? date('d M Y', strtotime($filter_date_from)) : 'Awal'; ?> - 
                <?php echo !empty($filter_date_to) ? date('d M Y', strtotime($filter_date_to)) : 'Sekarang'; ?>)
            <?php endif; ?>
        </div>
    </div>

    <div class="overflow-x-auto">
        <?php if (!empty($reminders_data)): ?>
            <table class="w-full" id="reportTable">
                <thead>
                    <tr class="text-left text-xs text-gray-500 uppercase tracking-wider border-b bg-gray-50">
                        <th class="pb-3">No</th>
                        <th class="pb-3">Tanggal Dibuat</th>
                        <th class="pb-3">No. Polisi</th>
                        <th class="pb-3">Nama Customer</th>
                        <th class="pb-3">No. Telepon</th>
                        <th class="pb-3">Model Kendaraan</th>
                        <th class="pb-3">Tahun</th>
                        <th class="pb-3">Status Kontak</th>
                        <th class="pb-3">Alasan</th>
                        <th class="pb-3">Booking</th>
                        <th class="pb-3">Dibuat Oleh</th>
                    </tr>
                </thead>
                <tbody class="text-sm">
                    <?php 
                    $no = 1;
                    foreach ($reminders_data as $row): 
                    ?>
                        <tr class="table-row border-b hover:bg-gray-50">
                            <td class="py-3"><?php echo $no++; ?></td>
                            <td class="py-3">
                                <p class="text-gray-800"><?php echo date('d M Y H:i', strtotime($row['created_at'])); ?></p>
                            </td>
                            <td class="py-3">
                                <p class="font-medium text-gray-800"><?php echo htmlspecialchars($row['police_number']); ?></p>
                            </td>
                            <td class="py-3">
                                <p class="font-medium text-gray-800"><?php echo htmlspecialchars($row['customer_name']); ?></p>
                            </td>
                            <td class="py-3">
                                <p class="text-gray-800"><?php echo htmlspecialchars($row['phone_number']); ?></p>
                            </td>
                            <td class="py-3">
                                <p class="text-gray-800"><?php echo htmlspecialchars($row['basic_model']); ?></p>
                            </td>
                            <td class="py-3">
                                <p class="text-gray-800"><?php echo htmlspecialchars($row['tahun']); ?></p>
                            </td>
                            <td class="py-3">
                                <?php if ($row['contactable'] === 'yes'): ?>
                                    <span class="px-2 py-1 text-xs rounded-full bg-green-100 text-green-800">Bisa Dihubungi</span>
                                <?php else: ?>
                                    <span class="px-2 py-1 text-xs rounded-full bg-red-100 text-red-800">Tidak Bisa Dihubungi</span>
                                <?php endif; ?>
                            </td>
                            <td class="py-3">
                                <p class="text-gray-800"><?php echo htmlspecialchars($row['reason']); ?></p>
                            </td>
                            <td class="py-3">
                                <?php if ($row['booking_date_time']): ?>
                                    <p class="text-gray-800"><?php echo date('d M Y H:i', strtotime($row['booking_date_time'])); ?></p>
                                <?php else: ?>
                                    <p class="text-gray-500">-</p>
                                <?php endif; ?>
                            </td>
                            <td class="py-3">
                                <p class="text-gray-800"><?php echo htmlspecialchars($row['reminder_by'] ?? '-'); ?></p>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="text-center py-8 text-gray-500">
                <i class="fas fa-bell text-4xl mb-2"></i>
                <p class="text-lg">Tidak ada data reminder yang ditemukan</p>
                <p class="text-sm">Coba ubah filter atau periode tanggal.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- JavaScript -->
<script>
// --- SERANGAN TERAKHIR: Cache-Busting Nuklir ---
// Script ini akan memaksa reload halaman dengan timestamp unik jika tidak ada.
// Ini untuk mengatasi cache server yang sangat bandel.
document.addEventListener('DOMContentLoaded', function() {
    if (!window.location.search.includes('_cb=')) {
        const separator = window.location.search ? '&' : '?';
        const newUrl = window.location.pathname + window.location.search + separator + '_cb=' + new Date().getTime();
        window.location.replace(newUrl); // Gunakan replace agar tidak masuk ke history back
    }
});

// Data untuk export, diambil dari PHP
const reportData = <?php echo json_encode($reminders_data); ?>;

document.addEventListener('DOMContentLoaded', function() {
    const filterForm = document.getElementById('filterForm');
    if (filterForm) {
        filterForm.addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Build query string
            const formData = new FormData(filterForm);
            const params = new URLSearchParams();
            
            for (const [key, value] of formData.entries()) {
                if (value) {
                    params.append(key, value);
                }
            }
            
            // Tambahkan cache-busting saat submit form juga
            window.location.href = '/report_reminder?' + params.toString() + '&_cb=' + new Date().getTime();
        });
    }
});

function exportToExcel() {
    if (!reportData || reportData.length === 0) {
        alert('Tidak ada data untuk diekspor!');
        return;
    }

    let csv = [];
    // Header CSV
    csv.push('"No","Tanggal Dibuat","No. Polisi","Nama Customer","No. Telepon","Model Kendaraan","Tahun","Status Kontak","Alasan","Booking","Dibuat Oleh"');
    
    // Data CSV
    reportData.forEach((row, index) => {
        const contactableStatus = row.contactable === 'yes' ? 'Bisa Dihubungi' : 'Tidak Bisa Dihubungi';
        const bookingDate = row.booking_date_time ? new Date(row.booking_date_time).toLocaleString('id-ID') : '-';
        const createdDate = new Date(row.created_at).toLocaleString('id-ID');

        let rowData = [
            index + 1,
            `"${createdDate}"`,
            `"${row.police_number}"`,
            `"${row.customer_name}"`,
            `"${row.phone_number}"`,
            `"${row.basic_model}"`,
            `"${row.tahun}"`,
            `"${contactableStatus}"`,
            `"${row.reason}"`,
            `"${bookingDate}"`,
            `"${row.reminder_by ?? '-'}"`
        ];
        csv.push(rowData.join(','));
    });
    
    // Create download link
    const csvFile = new Blob(["\ufeff" + csv.join('\n')], { type: 'text/csv;charset=utf-8;' }); // \ufeff for UTF-8 BOM
    const downloadLink = document.createElement('a');
    downloadLink.download = 'Laporan_Reminder_' + new Date().toISOString().split('T')[0] + '.csv';
    downloadLink.href = window.URL.createObjectURL(csvFile);
    downloadLink.style.display = 'none';
    
    document.body.appendChild(downloadLink);
    downloadLink.click();
    document.body.removeChild(downloadLink);
}
</script>

<style>
@media print {
    .no-print {
        display: none !important;
    }
    
    .glass-card {
        box-shadow: none !important;
        border: 1px solid #ddd !important;
    }
    
    table {
        font-size: 12px !important;
    }
    
    th, td {
        padding: 4px !important;
    }
}
</style>

<?php require_once '../includes/footer.php'; ?>