<?php
 $page_title = "Laporan";
 $page_subtitle = "Layani laporan reminder konsumen";

require_once '../includes/header.php';

// Get filter parameters
 $start_date = isset($_GET['start_date']) ? sanitize_input($_GET['start_date']) : date('Y-m-01');
 $end_date = isset($_GET['end_date']) ? sanitize_input($_GET['end_date']) : date('Y-m-t');
 $type = isset($_GET['type']) ? sanitize_input($_GET['type']) : '';

// Build query
 $sql = "SELECT r.*, c.name as customer_name, v.model 
        FROM reminders r 
        JOIN customers c ON r.customer_id = c.id 
        JOIN vehicles v ON r.vehicle_id = v.id 
        WHERE r.due_date BETWEEN ? AND ?";

 $params = [$start_date, $end_date];
 $types = "ss";

if (!empty($type)) {
    $sql .= " AND r.type = ?";
    $params[] = $type;
    $types .= "s";
}

 $sql .= " ORDER BY r.due_date ASC";

// Prepare and execute query
 $stmt = $conn->prepare($sql);
 $stmt->bind_param($types, ...$params);
 $stmt->execute();
 $result = $stmt->get_result();

// Get reminder types for filter
 $typesResult = $conn->query("SELECT DISTINCT type FROM reminders ORDER BY type");
 $types = [];
if ($typesResult->num_rows > 0) {
    while ($row = $typesResult->fetch_assoc()) {
        $types[] = $row['type'];
    }
}

// Calculate statistics
 $totalReminders = $result->num_rows;
 $completedReminders = 0;
 $pendingReminders = 0;

if ($totalReminders > 0) {
    // Reset result pointer and count by status
    $result->data_seek(0);
    while ($row = $result->fetch_assoc()) {
        if ($row['status'] == 'completed') {
            $completedReminders++;
        } else if ($row['status'] == 'pending') {
            $pendingReminders++;
        }
    }
    // Reset result pointer again for display
    $result->data_seek(0);
}

 $completionRate = $totalReminders > 0 ? round(($completedReminders / $totalReminders) * 100) : 0;
?>
<!-- Filter Section -->
<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Filter Laporan</h2>
        <div class="flex space-x-2 mt-2 md:mt-0">
            <button class="px-3 py-1 text-sm bg-suzuki-blue text-white rounded-lg" onclick="exportReport('pdf')">
                <i class="fas fa-file-pdf mr-1"></i> Export PDF
            </button>
            <button class="px-3 py-1 text-sm bg-green-600 text-white rounded-lg" onclick="exportReport('excel')">
                <i class="fas fa-file-excel mr-1"></i> Export Excel
            </button>
        </div>
    </div>
    
    <form method="GET" action="/pages/laporan.php" class="grid grid-cols-1 md:grid-cols-4 gap-4">
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Tanggal Mulai</label>
            <input type="date" name="start_date" value="<?php echo $start_date; ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
        </div>
        
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Tanggal Selesai</label>
            <input type="date" name="end_date" value="<?php echo $end_date; ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
        </div>
        
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Tipe</label>
            <select name="type" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                <option value="">Semua Tipe</option>
                <?php foreach ($types as $t): ?>
                <option value="<?php echo $t; ?>" <?php echo ($type == $t) ? 'selected' : ''; ?>><?php echo ucfirst($t); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div class="flex items-end">
            <button type="submit" class="w-full btn-primary px-4 py-2 text-white rounded-lg">
                <i class="fas fa-search mr-2"></i> Cari
            </button>
        </div>
    </form>
</div>

<!-- Statistics Cards -->
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-6">
    <div class="glass-card rounded-xl p-5 fade-in">
        <div class="flex items-center justify-between mb-4">
            <div class="stat-icon bg-blue-100">
                <i class="fas fa-bell text-suzuki-blue text-xl"></i>
            </div>
        </div>
        <h3 class="text-2xl font-bold text-gray-800"><?php echo $totalReminders; ?></h3>
        <p class="text-gray-600 text-sm">Total Reminder</p>
    </div>
    
    <div class="glass-card rounded-xl p-5 fade-in" style="animation-delay: 0.1s">
        <div class="flex items-center justify-between mb-4">
            <div class="stat-icon bg-green-100">
                <i class="fas fa-check-circle text-green-600 text-xl"></i>
            </div>
        </div>
        <h3 class="text-2xl font-bold text-gray-800"><?php echo $completedReminders; ?></h3>
        <p class="text-gray-600 text-sm">Selesai</p>
    </div>
    
    <div class="glass-card rounded-xl p-5 fade-in" style="animation-delay: 0.2s">
        <div class="flex items-center justify-between mb-4">
            <div class="stat-icon bg-purple-100">
                <i class="fas fa-percentage text-purple-600 text-xl"></i>
            </div>
        </div>
        <h3 class="text-2xl font-bold text-gray-800"><?php echo $completionRate; ?>%</h3>
        <p class="text-gray-600 text-sm">Tingkat Penyelesaian</p>
    </div>
</div>

<!-- Report Table -->
<div class="glass-card rounded-xl p-6 fade-in">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Laporan Reminder</h2>
        <div class="text-sm text-gray-500">
            Periode: <?php echo date('d M Y', strtotime($start_date)); ?> - <?php echo date('d M Y', strtotime($end_date)); ?>
        </div>
    </div>
    
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead>
                <tr class="text-left text-xs text-gray-500 uppercase tracking-wider border-b">
                    <th class="pb-3">ID</th>
                    <th class="pb-3">Konsumen</th>
                    <th class="pb-3">Kendaraan</th>
                    <th class="pb-3">Tipe</th>
                    <th class="pb-3">Deskripsi</th>
                    <th class="pb-3">Tanggal</th>
                    <th class="pb-3">Status</th>
                </tr>
            </thead>
            <tbody class="text-sm">
                <?php if ($result->num_rows > 0): ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                    <tr class="table-row border-b">
                        <td class="py-3">
                            <p class="text-gray-800">#<?php echo $row['id']; ?></p>
                        </td>
                        <td class="py-3">
                            <div class="flex items-center">
                                <img src="https://picsum.photos/seed/<?php echo $row['customer_name']; ?>/32/32.jpg" alt="User" class="w-8 h-8 rounded-lg mr-2">
                                <div>
                                    <p class="font-medium text-gray-800"><?php echo $row['customer_name']; ?></p>
                                </div>
                            </div>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo $row['model']; ?></p>
                        </td>
                        <td class="py-3">
                            <?php
                            $badgeClass = '';
                            $badgeText = '';
                            
                            switch ($row['type']) {
                                case 'servis':
                                    $badgeClass = 'bg-blue-100 text-blue-700';
                                    $badgeText = 'Servis';
                                    break;
                                case 'asuransi':
                                    $badgeClass = 'bg-orange-100 text-orange-700';
                                    $badgeText = 'Asuransi';
                                    break;
                                case 'stnk':
                                    $badgeClass = 'bg-green-100 text-green-700';
                                    $badgeText = 'STNK';
                                    break;
                            }
                            ?>
                            <span class="badge px-2 py-1 text-xs rounded-full <?php echo $badgeClass; ?>"><?php echo $badgeText; ?></span>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo $row['description']; ?></p>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo date('d M Y', strtotime($row['due_date'])); ?></p>
                        </td>
                        <td class="py-3">
                            <?php
                            $statusClass = '';
                            $statusText = '';
                            
                            switch ($row['status']) {
                                case 'pending':
                                    $statusClass = 'bg-yellow-100 text-yellow-700';
                                    $statusText = 'Menunggu';
                                    break;
                                case 'completed':
                                    $statusClass = 'bg-green-100 text-green-700';
                                    $statusText = 'Selesai';
                                    break;
                                case 'important':
                                    $statusClass = 'bg-orange-100 text-orange-700';
                                    $statusText = 'Penting';
                                    break;
                            }
                            ?>
                            <span class="badge px-2 py-1 text-xs rounded-full <?php echo $statusClass; ?>"><?php echo $statusText; ?></span>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" class="py-8 text-center text-gray-500">
                            <i class="fas fa-chart-bar text-4xl mb-2"></i>
                            <p>Tidak ada data laporan</p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>