
<?php
 $page_title = "Data Konsumen";
 $page_subtitle = "Kelola data konsumen Suzuki";

require_once '../includes/header.php';

// Get filter parameters
 $search = isset($_GET['search']) ? sanitize_input($_GET['search']) : '';

// Build query
 $sql = "SELECT * FROM customers WHERE 1=1";

 $params = [];
 $types = "";

if (!empty($search)) {
    $sql .= " AND (name LIKE ? OR email LIKE ? OR phone LIKE ? OR vehicle_model LIKE ?)";
    $searchParam = "%$search%";
    $params[] = $searchParam;
    $params[] = $searchParam;
    $params[] = $searchParam;
    $params[] = $searchParam;
    $types .= "ssss";
}

 $sql .= " ORDER BY name ASC";

// Prepare and execute query
 $stmt = $conn->prepare($sql);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
 $stmt->execute();
 $result = $stmt->get_result();
?>
<!-- Filter Section -->
<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Filter Konsumen</h2>
        <button class="btn-primary px-3 py-1 text-white rounded-lg text-sm mt-2 md:mt-0" onclick="addNewCustomer()">
            <i class="fas fa-plus mr-1"></i> Tambah Konsumen
        </button>
    </div>
    
    <form method="GET" action="/pages/konsumen.php" class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Pencarian</label>
            <input type="text" name="search" value="<?php echo $search; ?>" placeholder="Nama, email, telepon, atau model kendaraan" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
        </div>
        
        <div class="flex items-end">
            <button type="submit" class="w-full btn-primary px-4 py-2 text-white rounded-lg">
                <i class="fas fa-search mr-2"></i> Cari
            </button>
        </div>
    </form>
</div>

<!-- Customers Table -->
<div class="glass-card rounded-xl p-6 fade-in">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Daftar Konsumen</h2>
        <div class="text-sm text-gray-500">
            Menampilkan <?php echo $result->num_rows; ?> data
        </div>
    </div>
    
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead>
                <tr class="text-left text-xs text-gray-500 uppercase tracking-wider border-b">
                    <th class="pb-3">Nama</th>
                    <th class="pb-3">Email</th>
                    <th class="pb-3">Telepon</th>
                    <th class="pb-3">Kendaraan</th>
                    <th class="pb-3">Tanggal Bergabung</th>
                    <th class="pb-3">Aksi</th>
                </tr>
            </thead>
            <tbody class="text-sm">
                <?php if ($result->num_rows > 0): ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                    <tr class="table-row border-b">
                        <td class="py-3">
                            <div class="flex items-center">
                                <img src="https://picsum.photos/seed/<?php echo $row['name']; ?>/32/32.jpg" alt="User" class="w-8 h-8 rounded-lg mr-2">
                                <div>
                                    <p class="font-medium text-gray-800"><?php echo $row['name']; ?></p>
                                </div>
                            </div>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo $row['email']; ?></p>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo $row['phone']; ?></p>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo $row['vehicle_model']; ?></p>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo date('d M Y', strtotime($row['created_at'])); ?></p>
                        </td>
                        <td class="py-3">
                            <div class="flex space-x-2">
                                <button class="text-suzuki-blue hover:text-suzuki-dark" onclick="viewCustomer(<?php echo $row['id']; ?>)">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <button class="text-green-600 hover:text-green-800" onclick="editCustomer(<?php echo $row['id']; ?>)">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="text-red-600 hover:text-red-800" onclick="deleteCustomer(<?php echo $row['id']; ?>)">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" class="py-8 text-center text-gray-500">
                            <i class="fas fa-users text-4xl mb-2"></i>
                            <p>Tidak ada data konsumen</p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>