<?php
 $page_title = "Data Kendaraan";
 $page_subtitle = "Kelola data kendaraan konsumen";

require_once '../includes/header.php';

// Get filter parameters
 $search = isset($_GET['search']) ? sanitize_input($_GET['search']) : '';
 $type = isset($_GET['type']) ? sanitize_input($_GET['type']) : '';

// Build query
 $sql = "SELECT v.*, c.name as customer_name FROM vehicles v JOIN customers c ON v.customer_id = c.id WHERE 1=1";

 $params = [];
 $types = "";

if (!empty($search)) {
    $sql .= " AND (v.model LIKE ? OR v.license_plate LIKE ? OR c.name LIKE ?)";
    $searchParam = "%$search%";
    $params[] = $searchParam;
    $params[] = $searchParam;
    $params[] = $searchParam;
    $types .= "sss";
}

if (!empty($type)) {
    $sql .= " AND v.type = ?";
    $params[] = $type;
    $types .= "s";
}

 $sql .= " ORDER BY v.model ASC";

// Prepare and execute query
 $stmt = $conn->prepare($sql);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
 $stmt->execute();
 $result = $stmt->get_result();

// Get vehicle types for filter
 $typesResult = $conn->query("SELECT DISTINCT type FROM vehicles ORDER BY type");
 $types = [];
if ($typesResult->num_rows > 0) {
    while ($row = $typesResult->fetch_assoc()) {
        $types[] = $row['type'];
    }
}
?>
<!-- Filter Section -->
<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Filter Kendaraan</h2>
        <button class="btn-primary px-3 py-1 text-white rounded-lg text-sm mt-2 md:mt-0" onclick="addNewVehicle()">
            <i class="fas fa-plus mr-1"></i> Tambah Kendaraan
        </button>
    </div>
    
    <form method="GET" action="/pages/kendaraan" class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Pencarian</label>
            <input type="text" name="search" value="<?php echo $search; ?>" placeholder="Model, plat nomor, atau nama konsumen" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
        </div>
        
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Tipe Kendaraan</label>
            <select name="type" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                <option value="">Semua Tipe</option>
                <?php foreach ($types as $t): ?>
                <option value="<?php echo $t; ?>" <?php echo ($type == $t) ? 'selected' : ''; ?>><?php echo ucfirst($t); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        
        <div class="flex items-end">
            <button type="submit" class="w-full btn-primary px-4 py-2 text-white rounded-lg">
                <i class="fas fa-search mr-2"></i> Cari
            </button>
        </div>
    </form>
</div>

<!-- Vehicles Table -->
<div class="glass-card rounded-xl p-6 fade-in">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Daftar Kendaraan</h2>
        <div class="text-sm text-gray-500">
            Menampilkan <?php echo $result->num_rows; ?> data
        </div>
    </div>
    
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead>
                <tr class="text-left text-xs text-gray-500 uppercase tracking-wider border-b">
                    <th class="pb-3">Model</th>
                    <th class="pb-3">Plat Nomor</th>
                    <th class="pb-3">Tahun</th>
                    <th class="pb-3">Warna</th>
                    <th class="pb-3">Konsumen</th>
                    <th class="pb-3">Aksi</th>
                </tr>
            </thead>
            <tbody class="text-sm">
                <?php if ($result->num_rows > 0): ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                    <tr class="table-row border-b">
                        <td class="py-3">
                            <div class="flex items-center">
                                <img src="https://picsum.photos/seed/<?php echo $row['model']; ?>/32/32.jpg" alt="Vehicle" class="w-8 h-8 rounded-lg mr-2">
                                <div>
                                    <p class="font-medium text-gray-800"><?php echo $row['model']; ?></p>
                                    <p class="text-xs text-gray-500"><?php echo $row['type']; ?></p>
                                </div>
                            </div>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo $row['license_plate']; ?></p>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo $row['year']; ?></p>
                        </td>
                        <td class="py-3">
                            <div class="flex items-center">
                                <div class="w-4 h-4 rounded-full mr-2" style="background-color: <?php echo $row['color']; ?>"></div>
                                <p class="text-gray-800"><?php echo $row['color']; ?></p>
                            </div>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo $row['customer_name']; ?></p>
                        </td>
                        <td class="py-3">
                            <div class="flex space-x-2">
                                <button class="text-suzuki-blue hover:text-suzuki-dark" onclick="viewVehicle(<?php echo $row['id']; ?>)">
                                    <i class="fas fa-eye"></i>
                                </button>
                                <button class="text-green-600 hover:text-green-800" onclick="editVehicle(<?php echo $row['id']; ?>)">
                                    <i class="fas fa-edit"></i>
                                </button>
                                <button class="text-red-600 hover:text-red-800" onclick="deleteVehicle(<?php echo $row['id']; ?>)">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" class="py-8 text-center text-gray-500">
                            <i class="fas fa-car text-4xl mb-2"></i>
                            <p>Tidak ada data kendaraan</p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>