<?php
 $page_title = "Data PSF";
 $page_subtitle = "Kelola data Pre Sales Form";

require_once '../includes/header.php';

// Process form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'add':
                $user_id = $_POST['user_id'];
                $nama_lengkap = sanitize_input($_POST['nama_lengkap']);
                $no_telepon = sanitize_input($_POST['no_telepon']);
                $email = sanitize_input($_POST['email']);
                $alamat = sanitize_input($_POST['alamat']);
                $kendaraan_diminati = sanitize_input($_POST['kendaraan_diminati']);
                $tipe_kendaraan = sanitize_input($_POST['tipe_kendaraan']);
                $warna = sanitize_input($_POST['warna']);
                $tahun = $_POST['tahun'];
                $metode_pembayaran = sanitize_input($_POST['metode_pembayaran']);
                $anggaran = sanitize_input($_POST['anggaran']);
                $rencana_pembelian = $_POST['rencana_pembelian'];
                $keterangan = sanitize_input($_POST['keterangan']);
                $status = sanitize_input($_POST['status']);
                
                // Handle file upload
                $file_path = '';
                if (isset($_FILES['file_psf']) && $_FILES['file_psf']['error'] === UPLOAD_ERR_OK) {
                    $upload_dir = '../uploads/psf/';
                    if (!is_dir($upload_dir)) {
                        mkdir($upload_dir, 0755, true);
                    }
                    
                    $file_name = time() . '_' . basename($_FILES['file_psf']['name']);
                    $file_path = $upload_dir . $file_name;
                    
                    if (move_uploaded_file($_FILES['file_psf']['tmp_name'], $file_path)) {
                        // File uploaded successfully
                    } else {
                        $errorMessage = "Gagal mengunggah file.";
                        break;
                    }
                }
                
                $sql = "INSERT INTO data_psf (user_id, nama_lengkap, no_telepon, email, alamat, kendaraan_diminati, tipe_kendaraan, warna, tahun, metode_pembayaran, anggaran, rencana_pembelian, keterangan, status, file_path) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("issssssssisssss", $user_id, $nama_lengkap, $no_telepon, $email, $alamat, $kendaraan_diminati, $tipe_kendaraan, $warna, $tahun, $metode_pembayaran, $anggaran, $rencana_pembelian, $keterangan, $status, $file_path);
                $stmt->execute();
                
                $successMessage = "Data PSF berhasil ditambahkan";
                break;
                
            case 'edit':
                $psf_id = $_POST['psf_id'];
                $user_id = $_POST['user_id'];
                $nama_lengkap = sanitize_input($_POST['nama_lengkap']);
                $no_telepon = sanitize_input($_POST['no_telepon']);
                $email = sanitize_input($_POST['email']);
                $alamat = sanitize_input($_POST['alamat']);
                $kendaraan_diminati = sanitize_input($_POST['kendaraan_diminati']);
                $tipe_kendaraan = sanitize_input($_POST['tipe_kendaraan']);
                $warna = sanitize_input($_POST['warna']);
                $tahun = $_POST['tahun'];
                $metode_pembayaran = sanitize_input($_POST['metode_pembayaran']);
                $anggaran = sanitize_input($_POST['anggaran']);
                $rencana_pembelian = $_POST['rencana_pembelian'];
                $keterangan = sanitize_input($_POST['keterangan']);
                $status = sanitize_input($_POST['status']);
                
                // Handle file upload if new file is provided
                $file_update = '';
                if (isset($_FILES['file_psf']) && $_FILES['file_psf']['error'] === UPLOAD_ERR_OK) {
                    $upload_dir = '../uploads/psf/';
                    if (!is_dir($upload_dir)) {
                        mkdir($upload_dir, 0755, true);
                    }
                    
                    $file_name = time() . '_' . basename($_FILES['file_psf']['name']);
                    $file_path = $upload_dir . $file_name;
                    
                    if (move_uploaded_file($_FILES['file_psf']['tmp_name'], $file_path)) {
                        $file_update = ", file_path = ?";
                    } else {
                        $errorMessage = "Gagal mengunggah file.";
                        break;
                    }
                }
                
                $sql = "UPDATE data_psf SET user_id=?, nama_lengkap=?, no_telepon=?, email=?, alamat=?, kendaraan_diminati=?, tipe_kendaraan=?, warna=?, tahun=?, metode_pembayaran=?, anggaran=?, rencana_pembelian=?, keterangan=?, status=? $file_update WHERE id=?";
                $stmt = $conn->prepare($sql);
                
                if ($file_update) {
                    $stmt->bind_param("issssssssissssi", $user_id, $nama_lengkap, $no_telepon, $email, $alamat, $kendaraan_diminati, $tipe_kendaraan, $warna, $tahun, $metode_pembayaran, $anggaran, $rencana_pembelian, $keterangan, $status, $file_path, $psf_id);
                } else {
                    $stmt->bind_param("issssssssissssi", $user_id, $nama_lengkap, $no_telepon, $email, $alamat, $kendaraan_diminati, $tipe_kendaraan, $warna, $tahun, $metode_pembayaran, $anggaran, $rencana_pembelian, $keterangan, $status, $psf_id);
                }
                
                $stmt->execute();
                
                $successMessage = "Data PSF berhasil diperbarui";
                break;
                
            case 'delete':
                $psf_id = $_POST['psf_id'];
                
                // Get file path before deleting
                $sql = "SELECT file_path FROM data_psf WHERE id=?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("i", $psf_id);
                $stmt->execute();
                $result = $stmt->get_result();
                $psf = $result->fetch_assoc();
                
                // Delete file if exists
                if ($psf && file_exists($psf['file_path'])) {
                    unlink($psf['file_path']);
                }
                
                $sql = "DELETE FROM data_psf WHERE id=?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("i", $psf_id);
                $stmt->execute();
                
                $successMessage = "Data PSF berhasil dihapus";
                break;
        }
    }
}

// Get all PSF data with user information
 $sql = "SELECT psf.*, u.name as user_name FROM data_psf psf JOIN users u ON psf.user_id = u.id ORDER BY psf.created_at DESC";
 $result = $conn->query($sql);
 $psf_data = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $psf_data[] = $row;
    }
}

// Get PSF data for editing
 $edit_psf = null;
if (isset($_GET['edit']) && is_numeric($_GET['edit'])) {
    $psf_id = $_GET['edit'];
    $sql = "SELECT * FROM data_psf WHERE id=?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $psf_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $edit_psf = $result->fetch_assoc();
    }
}

// Get all users for dropdown
 $sql = "SELECT id, name FROM users ORDER BY name";
 $result = $conn->query($sql);
 $users = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $users[] = $row;
    }
}
?>

<!-- PSF Data Management -->
<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold text-gray-800">Daftar Data PSF</h2>
        <button onclick="openAddModal()" class="btn-primary px-4 py-2 text-white rounded-lg">
            <i class="fas fa-plus mr-2"></i> Tambah Data PSF
        </button>
    </div>
    
    <?php if (isset($successMessage)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-6" role="alert">
            <span class="block sm:inline"><?php echo $successMessage; ?></span>
        </div>
    <?php endif; ?>
    
    <?php if (isset($errorMessage)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-6" role="alert">
            <span class="block sm:inline"><?php echo $errorMessage; ?></span>
        </div>
    <?php endif; ?>
    
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Kendaraan</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tipe</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">File</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php foreach ($psf_data as $psf): ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $psf['id']; ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $psf['user_name']; ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $psf['nama_lengkap']; ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $psf['kendaraan_diminati']; ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $psf['tipe_kendaraan']; ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo $psf['status'] == 'follow-up' ? 'bg-yellow-100 text-yellow-800' : ($psf['status'] == 'deal' ? 'bg-green-100 text-green-800' : ($psf['status'] == 'cancel' ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-gray-800')); ?>">
                            <?php echo ucfirst($psf['status']); ?>
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                        <?php if ($psf['file_path']): ?>
                            <a href="/<?php echo $psf['file_path']; ?>" target="_blank" class="text-blue-600 hover:text-blue-900">
                                <i class="fas fa-file-pdf"></i> Lihat File
                            </a>
                        <?php else: ?>
                            <span class="text-gray-400">Tidak ada file</span>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <button onclick="openEditModal(<?php echo htmlspecialchars(json_encode($psf)); ?>)" class="text-indigo-600 hover:text-indigo-900 mr-3">
                            <i class="fas fa-edit"></i>
                        </button>
                        <button onclick="confirmDelete(<?php echo $psf['id']; ?>)" class="text-red-600 hover:text-red-900">
                            <i class="fas fa-trash"></i>
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Add PSF Modal -->
<div id="addModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-10 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-1/2 shadow-lg rounded-md bg-white max-h-screen overflow-y-auto">
        <div class="mt-3">
            <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Tambah Data PSF Baru</h3>
            <form method="POST" action="/pages/data-psf.php" enctype="multipart/form-data">
                <input type="hidden" name="action" value="add">
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="user_id" class="block text-sm font-medium text-gray-700 mb-1">User</label>
                        <select id="user_id" name="user_id" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                            <?php foreach ($users as $user): ?>
                            <option value="<?php echo $user['id']; ?>"><?php echo $user['name']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="nama_lengkap" class="block text-sm font-medium text-gray-700 mb-1">Nama Lengkap</label>
                        <input type="text" id="nama_lengkap" name="nama_lengkap" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="no_telepon" class="block text-sm font-medium text-gray-700 mb-1">No. Telepon</label>
                        <input type="text" id="no_telepon" name="no_telepon" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                        <input type="email" id="email" name="email" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="mb-4">
                    <label for="alamat" class="block text-sm font-medium text-gray-700 mb-1">Alamat</label>
                    <textarea id="alamat" name="alamat" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required></textarea>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="kendaraan_diminati" class="block text-sm font-medium text-gray-700 mb-1">Kendaraan Diminati</label>
                        <select id="kendaraan_diminati" name="kendaraan_diminati" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                            <option value="Swift">Swift</option>
                            <option value="Baleno">Baleno</option>
                            <option value="Ignis">Ignis</option>
                            <option value="S-Cross">S-Cross</option>
                            <option value="XL7">XL7</option>
                            <option value="Ertiga">Ertiga</option>
                            <option value="Jimny">Jimny</option>
                            <option value="APV">APV</option>
                            <option value="Carry">Carry</option>
                        </select>
                    </div>
                    <div>
                        <label for="tipe_kendaraan" class="block text-sm font-medium text-gray-700 mb-1">Tipe Kendaraan</label>
                        <input type="text" id="tipe_kendaraan" name="tipe_kendaraan" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                    <div>
                        <label for="warna" class="block text-sm font-medium text-gray-700 mb-1">Warna</label>
                        <input type="text" id="warna" name="warna" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="tahun" class="block text-sm font-medium text-gray-700 mb-1">Tahun</label>
                        <input type="number" id="tahun" name="tahun" min="2020" max="2024" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="metode_pembayaran" class="block text-sm font-medium text-gray-700 mb-1">Metode Pembayaran</label>
                        <select id="metode_pembayaran" name="metode_pembayaran" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                            <option value="Cash">Cash</option>
                            <option value="Kredit">Kredit</option>
                        </select>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="anggaran" class="block text-sm font-medium text-gray-700 mb-1">Anggaran</label>
                        <input type="text" id="anggaran" name="anggaran" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="rencana_pembelian" class="block text-sm font-medium text-gray-700 mb-1">Rencana Pembelian</label>
                        <input type="date" id="rencana_pembelian" name="rencana_pembelian" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                        <select id="status" name="status" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                            <option value="prospek">Prospek</option>
                            <option value="follow-up">Follow Up</option>
                            <option value="deal">Deal</option>
                            <option value="cancel">Cancel</option>
                        </select>
                    </div>
                    <div>
                        <label for="file_psf" class="block text-sm font-medium text-gray-700 mb-1">File PSF (PDF)</label>
                        <input type="file" id="file_psf" name="file_psf" accept=".pdf" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                    </div>
                </div>
                
                <div class="mb-4">
                    <label for="keterangan" class="block text-sm font-medium text-gray-700 mb-1">Keterangan</label>
                    <textarea id="keterangan" name="keterangan" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue"></textarea>
                </div>
                
                <div class="flex justify-end">
                    <button type="button" onclick="closeAddModal()" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-medium py-2 px-4 rounded mr-2">
                        Batal
                    </button>
                    <button type="submit" class="btn-primary px-4 py-2 text-white rounded-lg">
                        Tambah
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit PSF Modal -->
<div id="editModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-10 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-1/2 shadow-lg rounded-md bg-white max-h-screen overflow-y-auto">
        <div class="mt-3">
            <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Edit Data PSF</h3>
            <form method="POST" action="/pages/data-psf.php" enctype="multipart/form-data">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" id="edit_psf_id" name="psf_id">
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="edit_user_id" class="block text-sm font-medium text-gray-700 mb-1">User</label>
                        <select id="edit_user_id" name="user_id" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                            <?php foreach ($users as $user): ?>
                            <option value="<?php echo $user['id']; ?>"><?php echo $user['name']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="edit_nama_lengkap" class="block text-sm font-medium text-gray-700 mb-1">Nama Lengkap</label>
                        <input type="text" id="edit_nama_lengkap" name="nama_lengkap" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="edit_no_telepon" class="block text-sm font-medium text-gray-700 mb-1">No. Telepon</label>
                        <input type="text" id="edit_no_telepon" name="no_telepon" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="edit_email" class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                        <input type="email" id="edit_email" name="email" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="mb-4">
                    <label for="edit_alamat" class="block text-sm font-medium text-gray-700 mb-1">Alamat</label>
                    <textarea id="edit_alamat" name="alamat" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required></textarea>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="edit_kendaraan_diminati" class="block text-sm font-medium text-gray-700 mb-1">Kendaraan Diminati</label>
                        <select id="edit_kendaraan_diminati" name="kendaraan_diminati" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                            <option value="Swift">Swift</option>
                            <option value="Baleno">Baleno</option>
                            <option value="Ignis">Ignis</option>
                            <option value="S-Cross">S-Cross</option>
                            <option value="XL7">XL7</option>
                            <option value="Ertiga">Ertiga</option>
                            <option value="Jimny">Jimny</option>
                            <option value="APV">APV</option>
                            <option value="Carry">Carry</option>
                        </select>
                    </div>
                    <div>
                        <label for="edit_tipe_kendaraan" class="block text-sm font-medium text-gray-700 mb-1">Tipe Kendaraan</label>
                        <input type="text" id="edit_tipe_kendaraan" name="tipe_kendaraan" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                    <div>
                        <label for="edit_warna" class="block text-sm font-medium text-gray-700 mb-1">Warna</label>
                        <input type="text" id="edit_warna" name="warna" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="edit_tahun" class="block text-sm font-medium text-gray-700 mb-1">Tahun</label>
                        <input type="number" id="edit_tahun" name="tahun" min="2020" max="2024" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="edit_metode_pembayaran" class="block text-sm font-medium text-gray-700 mb-1">Metode Pembayaran</label>
                        <select id="edit_metode_pembayaran" name="metode_pembayaran" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                            <option value="Cash">Cash</option>
                            <option value="Kredit">Kredit</option>
                        </select>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="edit_anggaran" class="block text-sm font-medium text-gray-700 mb-1">Anggaran</label>
                        <input type="text" id="edit_anggaran" name="anggaran" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="edit_rencana_pembelian" class="block text-sm font-medium text-gray-700 mb-1">Rencana Pembelian</label>
                        <input type="date" id="edit_rencana_pembelian" name="rencana_pembelian" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="edit_status" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                        <select id="edit_status" name="status" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                            <option value="prospek">Prospek</option>
                            <option value="follow-up">Follow Up</option>
                            <option value="deal">Deal</option>
                            <option value="cancel">Cancel</option>
                        </select>
                    </div>
                    <div>
                        <label for="edit_file_psf" class="block text-sm font-medium text-gray-700 mb-1">File PSF (PDF) - Kosongkan jika tidak ingin mengubah</label>
                        <input type="file" id="edit_file_psf" name="file_psf" accept=".pdf" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                    </div>
                </div>
                
                <div class="mb-4">
                    <label for="edit_keterangan" class="block text-sm font-medium text-gray-700 mb-1">Keterangan</label>
                    <textarea id="edit_keterangan" name="keterangan" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue"></textarea>
                </div>
                
                <div class="flex justify-end">
                    <button type="button" onclick="closeEditModal()" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-medium py-2 px-4 rounded mr-2">
                        Batal
                    </button>
                    <button type="submit" class="btn-primary px-4 py-2 text-white rounded-lg">
                        Update
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3 text-center">
            <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100 mb-4">
                <i class="fas fa-exclamation-triangle text-red-600"></i>
            </div>
            <h3 class="text-lg leading-6 font-medium text-gray-900">Hapus Data PSF</h3>
            <div class="mt-2 px-7 py-3">
                <p class="text-sm text-gray-500">
                    Apakah Anda yakin ingin menghapus data PSF ini? Tindakan ini tidak dapat dibatalkan.
                </p>
            </div>
            <form method="POST" action="/pages/data-psf.php">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" id="delete_psf_id" name="psf_id">
                <div class="flex justify-center">
                    <button type="button" onclick="closeDeleteModal()" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-medium py-2 px-4 rounded mr-2">
                        Batal
                    </button>
                    <button type="submit" class="bg-red-600 hover:bg-red-700 text-white font-medium py-2 px-4 rounded">
                        Hapus
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    function openAddModal() {
        document.getElementById('addModal').classList.remove('hidden');
    }
    
    function closeAddModal() {
        document.getElementById('addModal').classList.add('hidden');
    }
    
    function openEditModal(psf) {
        document.getElementById('edit_psf_id').value = psf.id;
        document.getElementById('edit_user_id').value = psf.user_id;
        document.getElementById('edit_nama_lengkap').value = psf.nama_lengkap;
        document.getElementById('edit_no_telepon').value = psf.no_telepon;
        document.getElementById('edit_email').value = psf.email;
        document.getElementById('edit_alamat').value = psf.alamat;
        document.getElementById('edit_kendaraan_diminati').value = psf.kendaraan_diminati;
        document.getElementById('edit_tipe_kendaraan').value = psf.tipe_kendaraan;
        document.getElementById('edit_warna').value = psf.warna;
        document.getElementById('edit_tahun').value = psf.tahun;
        document.getElementById('edit_metode_pembayaran').value = psf.metode_pembayaran;
        document.getElementById('edit_anggaran').value = psf.anggaran;
        document.getElementById('edit_rencana_pembelian').value = psf.rencana_pembelian;
        document.getElementById('edit_status').value = psf.status;
        document.getElementById('edit_keterangan').value = psf.keterangan;
        document.getElementById('editModal').classList.remove('hidden');
    }
    
    function closeEditModal() {
        document.getElementById('editModal').classList.add('hidden');
    }
    
    function confirmDelete(psfId) {
        document.getElementById('delete_psf_id').value = psfId;
        document.getElementById('deleteModal').classList.remove('hidden');
    }
    
    function closeDeleteModal() {
        document.getElementById('deleteModal').classList.add('hidden');
    }
</script>

<?php require_once '../includes/footer.php'; ?>