<?php
 $page_title = "Data DRH";
 $page_subtitle = "Kelola data Daftar Riwayat Hidup";

require_once '../includes/header.php';

// Process form submission
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'add':
                $user_id = $_POST['user_id'];
                $nama_lengkap = sanitize_input($_POST['nama_lengkap']);
                $tempat_lahir = sanitize_input($_POST['tempat_lahir']);
                $tanggal_lahir = $_POST['tanggal_lahir'];
                $jenis_kelamin = $_POST['jenis_kelamin'];
                $agama = sanitize_input($_POST['agama']);
                $alamat = sanitize_input($_POST['alamat']);
                $no_telepon = sanitize_input($_POST['no_telepon']);
                $email = sanitize_input($_POST['email']);
                $pendidikan_terakhir = sanitize_input($_POST['pendidikan_terakhir']);
                $pekerjaan = sanitize_input($_POST['pekerjaan']);
                $status_perkawinan = sanitize_input($_POST['status_perkawinan']);
                
                // Handle file upload
                $file_path = '';
                if (isset($_FILES['file_drh']) && $_FILES['file_drh']['error'] === UPLOAD_ERR_OK) {
                    $upload_dir = '../uploads/drh/';
                    if (!is_dir($upload_dir)) {
                        mkdir($upload_dir, 0755, true);
                    }
                    
                    $file_name = time() . '_' . basename($_FILES['file_drh']['name']);
                    $file_path = $upload_dir . $file_name;
                    
                    if (move_uploaded_file($_FILES['file_drh']['tmp_name'], $file_path)) {
                        // File uploaded successfully
                    } else {
                        $errorMessage = "Gagal mengunggah file.";
                        break;
                    }
                }
                
                $sql = "INSERT INTO data_drh (user_id, nama_lengkap, tempat_lahir, tanggal_lahir, jenis_kelamin, agama, alamat, no_telepon, email, pendidikan_terakhir, pekerjaan, status_perkawinan, file_path) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("issssssssssss", $user_id, $nama_lengkap, $tempat_lahir, $tanggal_lahir, $jenis_kelamin, $agama, $alamat, $no_telepon, $email, $pendidikan_terakhir, $pekerjaan, $status_perkawinan, $file_path);
                $stmt->execute();
                
                $successMessage = "Data DRH berhasil ditambahkan";
                break;
                
            case 'edit':
                $drh_id = $_POST['drh_id'];
                $user_id = $_POST['user_id'];
                $nama_lengkap = sanitize_input($_POST['nama_lengkap']);
                $tempat_lahir = sanitize_input($_POST['tempat_lahir']);
                $tanggal_lahir = $_POST['tanggal_lahir'];
                $jenis_kelamin = $_POST['jenis_kelamin'];
                $agama = sanitize_input($_POST['agama']);
                $alamat = sanitize_input($_POST['alamat']);
                $no_telepon = sanitize_input($_POST['no_telepon']);
                $email = sanitize_input($_POST['email']);
                $pendidikan_terakhir = sanitize_input($_POST['pendidikan_terakhir']);
                $pekerjaan = sanitize_input($_POST['pekerjaan']);
                $status_perkawinan = sanitize_input($_POST['status_perkawinan']);
                
                // Handle file upload if new file is provided
                $file_update = '';
                if (isset($_FILES['file_drh']) && $_FILES['file_drh']['error'] === UPLOAD_ERR_OK) {
                    $upload_dir = '../uploads/drh/';
                    if (!is_dir($upload_dir)) {
                        mkdir($upload_dir, 0755, true);
                    }
                    
                    $file_name = time() . '_' . basename($_FILES['file_drh']['name']);
                    $file_path = $upload_dir . $file_name;
                    
                    if (move_uploaded_file($_FILES['file_drh']['tmp_name'], $file_path)) {
                        $file_update = ", file_path = ?";
                    } else {
                        $errorMessage = "Gagal mengunggah file.";
                        break;
                    }
                }
                
                $sql = "UPDATE data_drh SET user_id=?, nama_lengkap=?, tempat_lahir=?, tanggal_lahir=?, jenis_kelamin=?, agama=?, alamat=?, no_telepon=?, email=?, pendidikan_terakhir=?, pekerjaan=?, status_perkawinan=? $file_update WHERE id=?";
                $stmt = $conn->prepare($sql);
                
                if ($file_update) {
                    $stmt->bind_param("isssssssssssi", $user_id, $nama_lengkap, $tempat_lahir, $tanggal_lahir, $jenis_kelamin, $agama, $alamat, $no_telepon, $email, $pendidikan_terakhir, $pekerjaan, $status_perkawinan, $file_path, $drh_id);
                } else {
                    $stmt->bind_param("isssssssssssi", $user_id, $nama_lengkap, $tempat_lahir, $tanggal_lahir, $jenis_kelamin, $agama, $alamat, $no_telepon, $email, $pendidikan_terakhir, $pekerjaan, $status_perkawinan, $drh_id);
                }
                
                $stmt->execute();
                
                $successMessage = "Data DRH berhasil diperbarui";
                break;
                
            case 'delete':
                $drh_id = $_POST['drh_id'];
                
                // Get file path before deleting
                $sql = "SELECT file_path FROM data_drh WHERE id=?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("i", $drh_id);
                $stmt->execute();
                $result = $stmt->get_result();
                $drh = $result->fetch_assoc();
                
                // Delete file if exists
                if ($drh && file_exists($drh['file_path'])) {
                    unlink($drh['file_path']);
                }
                
                $sql = "DELETE FROM data_drh WHERE id=?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("i", $drh_id);
                $stmt->execute();
                
                $successMessage = "Data DRH berhasil dihapus";
                break;
        }
    }
}

// Get all DRH data with user information
 $sql = "SELECT drh.*, u.name as user_name FROM data_drh drh JOIN users u ON drh.user_id = u.id ORDER BY drh.created_at DESC";
 $result = $conn->query($sql);
 $drh_data = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $drh_data[] = $row;
    }
}

// Get DRH data for editing
 $edit_drh = null;
if (isset($_GET['edit']) && is_numeric($_GET['edit'])) {
    $drh_id = $_GET['edit'];
    $sql = "SELECT * FROM data_drh WHERE id=?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $drh_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $edit_drh = $result->fetch_assoc();
    }
}

// Get all users for dropdown
 $sql = "SELECT id, name FROM users ORDER BY name";
 $result = $conn->query($sql);
 $users = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $users[] = $row;
    }
}
?>

<!-- DRH Data Management -->
<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <div class="flex items-center justify-between mb-6">
        <h2 class="text-lg font-semibold text-gray-800">Daftar Data DRH</h2>
        <button onclick="openAddModal()" class="btn-primary px-4 py-2 text-white rounded-lg">
            <i class="fas fa-plus mr-2"></i> Tambah Data DRH
        </button>
    </div>
    
    <?php if (isset($successMessage)): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-6" role="alert">
            <span class="block sm:inline"><?php echo $successMessage; ?></span>
        </div>
    <?php endif; ?>
    
    <?php if (isset($errorMessage)): ?>
        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-6" role="alert">
            <span class="block sm:inline"><?php echo $errorMessage; ?></span>
        </div>
    <?php endif; ?>
    
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">ID</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Nama Lengkap</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal Lahir</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jenis Kelamin</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Telepon</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">File</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                <?php foreach ($drh_data as $drh): ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $drh['id']; ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $drh['user_name']; ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $drh['nama_lengkap']; ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo date('d M Y', strtotime($drh['tanggal_lahir'])); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $drh['jenis_kelamin']; ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo $drh['no_telepon']; ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                        <?php if ($drh['file_path']): ?>
                            <a href="/<?php echo $drh['file_path']; ?>" target="_blank" class="text-blue-600 hover:text-blue-900">
                                <i class="fas fa-file-pdf"></i> Lihat File
                            </a>
                        <?php else: ?>
                            <span class="text-gray-400">Tidak ada file</span>
                        <?php endif; ?>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                        <button onclick="openEditModal(<?php echo htmlspecialchars(json_encode($drh)); ?>)" class="text-indigo-600 hover:text-indigo-900 mr-3">
                            <i class="fas fa-edit"></i>
                        </button>
                        <button onclick="confirmDelete(<?php echo $drh['id']; ?>)" class="text-red-600 hover:text-red-900">
                            <i class="fas fa-trash"></i>
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Add DRH Modal -->
<div id="addModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-10 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-1/2 shadow-lg rounded-md bg-white max-h-screen overflow-y-auto">
        <div class="mt-3">
            <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Tambah Data DRH Baru</h3>
            <form method="POST" action="/pages/data-drh.php" enctype="multipart/form-data">
                <input type="hidden" name="action" value="add">
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="user_id" class="block text-sm font-medium text-gray-700 mb-1">User</label>
                        <select id="user_id" name="user_id" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                            <?php foreach ($users as $user): ?>
                            <option value="<?php echo $user['id']; ?>"><?php echo $user['name']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="nama_lengkap" class="block text-sm font-medium text-gray-700 mb-1">Nama Lengkap</label>
                        <input type="text" id="nama_lengkap" name="nama_lengkap" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="tempat_lahir" class="block text-sm font-medium text-gray-700 mb-1">Tempat Lahir</label>
                        <input type="text" id="tempat_lahir" name="tempat_lahir" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="tanggal_lahir" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Lahir</label>
                        <input type="date" id="tanggal_lahir" name="tanggal_lahir" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="jenis_kelamin" class="block text-sm font-medium text-gray-700 mb-1">Jenis Kelamin</label>
                        <select id="jenis_kelamin" name="jenis_kelamin" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                            <option value="Laki-laki">Laki-laki</option>
                            <option value="Perempuan">Perempuan</option>
                        </select>
                    </div>
                    <div>
                        <label for="agama" class="block text-sm font-medium text-gray-700 mb-1">Agama</label>
                        <input type="text" id="agama" name="agama" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="mb-4">
                    <label for="alamat" class="block text-sm font-medium text-gray-700 mb-1">Alamat</label>
                    <textarea id="alamat" name="alamat" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required></textarea>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="no_telepon" class="block text-sm font-medium text-gray-700 mb-1">No. Telepon</label>
                        <input type="text" id="no_telepon" name="no_telepon" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                        <input type="email" id="email" name="email" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                    <div>
                        <label for="pendidikan_terakhir" class="block text-sm font-medium text-gray-700 mb-1">Pendidikan Terakhir</label>
                        <input type="text" id="pendidikan_terakhir" name="pendidikan_terakhir" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="pekerjaan" class="block text-sm font-medium text-gray-700 mb-1">Pekerjaan</label>
                        <input type="text" id="pekerjaan" name="pekerjaan" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="status_perkawinan" class="block text-sm font-medium text-gray-700 mb-1">Status Perkawinan</label>
                        <select id="status_perkawinan" name="status_perkawinan" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                            <option value="Belum Menikah">Belum Menikah</option>
                            <option value="Menikah">Menikah</option>
                            <option value="Duda/Janda">Duda/Janda</option>
                        </select>
                    </div>
                </div>
                
                <div class="mb-4">
                    <label for="file_drh" class="block text-sm font-medium text-gray-700 mb-1">File DRH (PDF)</label>
                    <input type="file" id="file_drh" name="file_drh" accept=".pdf" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                </div>
                
                <div class="flex justify-end">
                    <button type="button" onclick="closeAddModal()" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-medium py-2 px-4 rounded mr-2">
                        Batal
                    </button>
                    <button type="submit" class="btn-primary px-4 py-2 text-white rounded-lg">
                        Tambah
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit DRH Modal -->
<div id="editModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-10 mx-auto p-5 border w-11/12 md:w-3/4 lg:w-1/2 shadow-lg rounded-md bg-white max-h-screen overflow-y-auto">
        <div class="mt-3">
            <h3 class="text-lg leading-6 font-medium text-gray-900 mb-4">Edit Data DRH</h3>
            <form method="POST" action="/pages/data-drh.php" enctype="multipart/form-data">
                <input type="hidden" name="action" value="edit">
                <input type="hidden" id="edit_drh_id" name="drh_id">
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="edit_user_id" class="block text-sm font-medium text-gray-700 mb-1">User</label>
                        <select id="edit_user_id" name="user_id" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                            <?php foreach ($users as $user): ?>
                            <option value="<?php echo $user['id']; ?>"><?php echo $user['name']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div>
                        <label for="edit_nama_lengkap" class="block text-sm font-medium text-gray-700 mb-1">Nama Lengkap</label>
                        <input type="text" id="edit_nama_lengkap" name="nama_lengkap" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="edit_tempat_lahir" class="block text-sm font-medium text-gray-700 mb-1">Tempat Lahir</label>
                        <input type="text" id="edit_tempat_lahir" name="tempat_lahir" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="edit_tanggal_lahir" class="block text-sm font-medium text-gray-700 mb-1">Tanggal Lahir</label>
                        <input type="date" id="edit_tanggal_lahir" name="tanggal_lahir" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="edit_jenis_kelamin" class="block text-sm font-medium text-gray-700 mb-1">Jenis Kelamin</label>
                        <select id="edit_jenis_kelamin" name="jenis_kelamin" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                            <option value="Laki-laki">Laki-laki</option>
                            <option value="Perempuan">Perempuan</option>
                        </select>
                    </div>
                    <div>
                        <label for="edit_agama" class="block text-sm font-medium text-gray-700 mb-1">Agama</label>
                        <input type="text" id="edit_agama" name="agama" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="mb-4">
                    <label for="edit_alamat" class="block text-sm font-medium text-gray-700 mb-1">Alamat</label>
                    <textarea id="edit_alamat" name="alamat" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required></textarea>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div>
                        <label for="edit_no_telepon" class="block text-sm font-medium text-gray-700 mb-1">No. Telepon</label>
                        <input type="text" id="edit_no_telepon" name="no_telepon" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="edit_email" class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                        <input type="email" id="edit_email" name="email" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-4">
                    <div>
                        <label for="edit_pendidikan_terakhir" class="block text-sm font-medium text-gray-700 mb-1">Pendidikan Terakhir</label>
                        <input type="text" id="edit_pendidikan_terakhir" name="pendidikan_terakhir" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="edit_pekerjaan" class="block text-sm font-medium text-gray-700 mb-1">Pekerjaan</label>
                        <input type="text" id="edit_pekerjaan" name="pekerjaan" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                    </div>
                    <div>
                        <label for="edit_status_perkawinan" class="block text-sm font-medium text-gray-700 mb-1">Status Perkawinan</label>
                        <select id="edit_status_perkawinan" name="status_perkawinan" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue" required>
                            <option value="Belum Menikah">Belum Menikah</option>
                            <option value="Menikah">Menikah</option>
                            <option value="Duda/Janda">Duda/Janda</option>
                        </select>
                    </div>
                </div>
                
                <div class="mb-4">
                    <label for="edit_file_drh" class="block text-sm font-medium text-gray-700 mb-1">File DRH (PDF) - Kosongkan jika tidak ingin mengubah</label>
                    <input type="file" id="edit_file_drh" name="file_drh" accept=".pdf" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                </div>
                
                <div class="flex justify-end">
                    <button type="button" onclick="closeEditModal()" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-medium py-2 px-4 rounded mr-2">
                        Batal
                    </button>
                    <button type="submit" class="btn-primary px-4 py-2 text-white rounded-lg">
                        Update
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div id="deleteModal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden">
    <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
        <div class="mt-3 text-center">
            <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-red-100 mb-4">
                <i class="fas fa-exclamation-triangle text-red-600"></i>
            </div>
            <h3 class="text-lg leading-6 font-medium text-gray-900">Hapus Data DRH</h3>
            <div class="mt-2 px-7 py-3">
                <p class="text-sm text-gray-500">
                    Apakah Anda yakin ingin menghapus data DRH ini? Tindakan ini tidak dapat dibatalkan.
                </p>
            </div>
            <form method="POST" action="/pages/data-drh.php">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" id="delete_drh_id" name="drh_id">
                <div class="flex justify-center">
                    <button type="button" onclick="closeDeleteModal()" class="bg-gray-300 hover:bg-gray-400 text-gray-800 font-medium py-2 px-4 rounded mr-2">
                        Batal
                    </button>
                    <button type="submit" class="bg-red-600 hover:bg-red-700 text-white font-medium py-2 px-4 rounded">
                        Hapus
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    function openAddModal() {
        document.getElementById('addModal').classList.remove('hidden');
    }
    
    function closeAddModal() {
        document.getElementById('addModal').classList.add('hidden');
    }
    
    function openEditModal(drh) {
        document.getElementById('edit_drh_id').value = drh.id;
        document.getElementById('edit_user_id').value = drh.user_id;
        document.getElementById('edit_nama_lengkap').value = drh.nama_lengkap;
        document.getElementById('edit_tempat_lahir').value = drh.tempat_lahir;
        document.getElementById('edit_tanggal_lahir').value = drh.tanggal_lahir;
        document.getElementById('edit_jenis_kelamin').value = drh.jenis_kelamin;
        document.getElementById('edit_agama').value = drh.agama;
        document.getElementById('edit_alamat').value = drh.alamat;
        document.getElementById('edit_no_telepon').value = drh.no_telepon;
        document.getElementById('edit_email').value = drh.email;
        document.getElementById('edit_pendidikan_terakhir').value = drh.pendidikan_terakhir;
        document.getElementById('edit_pekerjaan').value = drh.pekerjaan;
        document.getElementById('edit_status_perkawinan').value = drh.status_perkawinan;
        document.getElementById('editModal').classList.remove('hidden');
    }
    
    function closeEditModal() {
        document.getElementById('editModal').classList.add('hidden');
    }
    
    function confirmDelete(drhId) {
        document.getElementById('delete_drh_id').value = drhId;
        document.getElementById('deleteModal').classList.remove('hidden');
    }
    
    function closeDeleteModal() {
        document.getElementById('deleteModal').classList.add('hidden');
    }
</script>

<?php require_once '../includes/footer.php'; ?>