<?php
 $page_title = "Analytics";
 $page_subtitle = "Analisis data reminder konsumen";

require_once '../includes/header.php';

// Get filter parameters
 $period = isset($_GET['period']) ? sanitize_input($_GET['period']) : 'month';

// Set date range based on period
switch ($period) {
    case 'week':
        $start_date = date('Y-m-d', strtotime('-7 days'));
        $end_date = date('Y-m-d');
        break;
    case 'month':
        $start_date = date('Y-m-01');
        $end_date = date('Y-m-t');
        break;
    case 'year':
        $start_date = date('Y-01-01');
        $end_date = date('Y-12-31');
        break;
    default:
        $start_date = date('Y-m-01');
        $end_date = date('Y-m-t');
}

// Get reminder statistics by type
 $sql = "SELECT type, COUNT(*) as count 
        FROM reminders 
        WHERE due_date BETWEEN ? AND ? 
        GROUP BY type";
 $stmt = $conn->prepare($sql);
 $stmt->bind_param("ss", $start_date, $end_date);
 $stmt->execute();
 $result = $stmt->get_result();

 $reminderTypes = [];
 $totalReminders = 0;

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $reminderTypes[$row['type']] = $row['count'];
        $totalReminders += $row['count'];
    }
}

// Get reminder statistics by status
 $sql = "SELECT status, COUNT(*) as count 
        FROM reminders 
        WHERE due_date BETWEEN ? AND ? 
        GROUP BY status";
 $stmt = $conn->prepare($sql);
 $stmt->bind_param("ss", $start_date, $end_date);
 $stmt->execute();
 $result = $stmt->get_result();

 $reminderStatuses = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $reminderStatuses[$row['status']] = $row['count'];
    }
}

// Get daily reminder counts for chart
 $sql = "SELECT DATE(due_date) as date, COUNT(*) as count 
        FROM reminders 
        WHERE due_date BETWEEN ? AND ? 
        GROUP BY DATE(due_date) 
        ORDER BY date";
 $stmt = $conn->prepare($sql);
 $stmt->bind_param("ss", $start_date, $end_date);
 $stmt->execute();
 $result = $stmt->get_result();

 $dailyCounts = [];
 $labels = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $dailyCounts[] = $row['count'];
        $labels[] = date('d M', strtotime($row['date']));
    }
}

// Get top customers by reminder count
 $sql = "SELECT c.name, COUNT(r.id) as count 
        FROM customers c 
        JOIN reminders r ON c.id = r.customer_id 
        WHERE r.due_date BETWEEN ? AND ? 
        GROUP BY c.id 
        ORDER BY count DESC 
        LIMIT 5";
 $stmt = $conn->prepare($sql);
 $stmt->bind_param("ss", $start_date, $end_date);
 $stmt->execute();
 $result = $stmt->get_result();

 $topCustomers = [];

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $topCustomers[] = $row;
    }
}
?>
<!-- Filter Section -->
<div class="glass-card rounded-xl p-6 mb-6 fade-in">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-4">
        <h2 class="text-lg font-semibold text-gray-800">Filter Analytics</h2>
    </div>
    
    <form method="GET" action="/pages/analytics.php" class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Periode</label>
            <select name="period" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
                <option value="week" <?php echo ($period == 'week') ? 'selected' : ''; ?>>7 Hari Terakhir</option>
                <option value="month" <?php echo ($period == 'month') ? 'selected' : ''; ?>>Bulan Ini</option>
                <option value="year" <?php echo ($period == 'year') ? 'selected' : ''; ?>>Tahun Ini</option>
            </select>
        </div>
        
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Tanggal Mulai</label>
            <input type="date" name="start_date" value="<?php echo $start_date; ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
        </div>
        
        <div>
            <label class="block text-sm font-medium text-gray-700 mb-1">Tanggal Selesai</label>
            <input type="date" name="end_date" value="<?php echo $end_date; ?>" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-suzuki-blue">
        </div>
        
        <div class="md:col-span-3 flex items-end">
            <button type="submit" class="btn-primary px-4 py-2 text-white rounded-lg">
                <i class="fas fa-search mr-2"></i> Terapkan Filter
            </button>
        </div>
    </form>
</div>

<!-- Analytics Overview -->
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
    <div class="glass-card rounded-xl p-5 fade-in">
        <div class="flex items-center justify-between mb-4">
            <div class="stat-icon bg-blue-100">
                <i class="fas fa-bell text-suzuki-blue text-xl"></i>
            </div>
        </div>
        <h3 class="text-2xl font-bold text-gray-800"><?php echo $totalReminders; ?></h3>
        <p class="text-gray-600 text-sm">Total Reminder</p>
    </div>
    
    <div class="glass-card rounded-xl p-5 fade-in" style="animation-delay: 0.1s">
        <div class="flex items-center justify-between mb-4">
            <div class="stat-icon bg-green-100">
                <i class="fas fa-check-circle text-green-600 text-xl"></i>
            </div>
        </div>
        <h3 class="text-2xl font-bold text-gray-800"><?php echo isset($reminderStatuses['completed']) ? $reminderStatuses['completed'] : 0; ?></h3>
        <p class="text-gray-600 text-sm">Selesai</p>
    </div>
    
    <div class="glass-card rounded-xl p-5 fade-in" style="animation-delay: 0.2s">
        <div class="flex items-center justify-between mb-4">
            <div class="stat-icon bg-yellow-100">
                <i class="fas fa-clock text-yellow-600 text-xl"></i>
            </div>
        </div>
        <h3 class="text-2xl font-bold text-gray-800"><?php echo isset($reminderStatuses['pending']) ? $reminderStatuses['pending'] : 0; ?></h3>
        <p class="text-gray-600 text-sm">Menunggu</p>
    </div>
    
    <div class="glass-card rounded-xl p-5 fade-in" style="animation-delay: 0.3s">
        <div class="flex items-center justify-between mb-4">
            <div class="stat-icon bg-purple-100">
                <i class="fas fa-percentage text-purple-600 text-xl"></i>
            </div>
        </div>
        <h3 class="text-2xl font-bold text-gray-800"><?php echo $totalReminders > 0 ? round((isset($reminderStatuses['completed']) ? $reminderStatuses['completed'] : 0) / $totalReminders * 100) : 0; ?>%</h3>
        <p class="text-gray-600 text-sm">Tingkat Penyelesaian</p>
    </div>
</div>

<!-- Charts Section -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
    <!--
<!-- Charts Section -->
<div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
    <!-- Daily Trend Chart -->
    <div class="glass-card rounded-xl p-6 fade-in">
        <div class="flex items-center justify-between mb-4">
            <div>
                <h2 class="text-lg font-semibold text-gray-800">Tren Harian</h2>
                <p class="text-sm text-gray-500">Jumlah reminder per hari</p>
            </div>
            <select class="text-sm border border-gray-200 rounded-lg px-3 py-1 focus:outline-none" onchange="updateDailyChart(this.value)">
                <option value="week">7 Hari</option>
                <option value="month">30 Hari</option>
            </select>
        </div>
        <div style="height: 250px;">
            <canvas id="dailyChart"></canvas>
        </div>
    </div>
    
    <!-- Type Distribution Chart -->
    <div class="glass-card rounded-xl p-6 fade-in">
        <div class="flex items-center justify-between mb-4">
            <div>
                <h2 class="text-lg font-semibold text-gray-800">Distribusi Tipe</h2>
                <p class="text-sm text-gray-500">Reminder berdasarkan tipe</p>
            </div>
        </div>
        <div style="height: 250px;">
            <canvas id="typeChart"></canvas>
        </div>
    </div>
</div>

<!-- Top Customers Section -->
<div class="glass-card rounded-xl p-6 fade-in">
    <div class="flex items-center justify-between mb-4">
        <div>
            <h2 class="text-lg font-semibold text-gray-800">Konsumen Teratas</h2>
            <p class="text-sm text-gray-500">Konsumen dengan reminder terbanyak</p>
        </div>
    </div>
    
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead>
                <tr class="text-left text-xs text-gray-500 uppercase tracking-wider border-b">
                    <th class="pb-3">Peringkat</th>
                    <th class="pb-3">Nama Konsumen</th>
                    <th class="pb-3">Jumlah Reminder</th>
                    <th class="pb-3">Persentase</th>
                </tr>
            </thead>
            <tbody class="text-sm">
                <?php if (count($topCustomers) > 0): ?>
                    <?php foreach ($topCustomers as $index => $customer): ?>
                    <tr class="table-row border-b">
                        <td class="py-3">
                            <div class="flex items-center justify-center w-8 h-8 rounded-full bg-suzuki-blue text-white font-bold">
                                <?php echo $index + 1; ?>
                            </div>
                        </td>
                        <td class="py-3">
                            <div class="flex items-center">
                                <img src="https://picsum.photos/seed/<?php echo $customer['name']; ?>/32/32.jpg" alt="User" class="w-8 h-8 rounded-lg mr-2">
                                <div>
                                    <p class="font-medium text-gray-800"><?php echo $customer['name']; ?></p>
                                </div>
                            </div>
                        </td>
                        <td class="py-3">
                            <p class="text-gray-800"><?php echo $customer['count']; ?></p>
                        </td>
                        <td class="py-3">
                            <div class="flex items-center">
                                <div class="w-32 bg-gray-200 rounded-full h-2 mr-2">
                                    <div class="bg-suzuki-blue h-2 rounded-full" style="width: <?php echo $totalReminders > 0 ? round(($customer['count'] / $totalReminders) * 100) : 0; ?>%"></div>
                                </div>
                                <span class="text-gray-800"><?php echo $totalReminders > 0 ? round(($customer['count'] / $totalReminders) * 100) : 0; ?>%</span>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4" class="py-8 text-center text-gray-500">
                            <i class="fas fa-users text-4xl mb-2"></i>
                            <p>Tidak ada data konsumen</p>
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
// Initialize Daily Trend Chart
const dailyCtx = document.getElementById('dailyChart');
if (dailyCtx) {
    new Chart(dailyCtx.getContext('2d'), {
        type: 'line',
        data: {
            labels: <?php echo json_encode($labels); ?>,
            datasets: [{
                label: 'Jumlah Reminder',
                data: <?php echo json_encode($dailyCounts); ?>,
                borderColor: '#0033a0',
                backgroundColor: 'rgba(0, 51, 160, 0.1)',
                tension: 0.4,
                fill: true
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(0, 0, 0, 0.05)'
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });
}

// Initialize Type Distribution Chart
const typeCtx = document.getElementById('typeChart');
if (typeCtx) {
    new Chart(typeCtx.getContext('2d'), {
        type: 'doughnut',
        data: {
            labels: <?php echo json_encode(array_keys($reminderTypes)); ?>,
            datasets: [{
                data: <?php echo json_encode(array_values($reminderTypes)); ?>,
                backgroundColor: [
                    '#0033a0',
                    '#ff6600',
                    '#10b981',
                    '#8b5cf6',
                    '#f59e0b'
                ],
                borderWidth: 0
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        usePointStyle: true,
                        padding: 15
                    }
                }
            }
        }
    });
}

function updateDailyChart(period) {
    // Update chart based on selected period
    console.log('Updating chart for period:', period);
    // Implement chart update logic here
}
</script>

<?php require_once '../includes/footer.php'; ?>