<?php
session_start();
require_once '../config/database.php';
require_login();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Suzuki Dashboard - <?php echo isset($page_title) ? $page_title : 'Dashboard'; ?></title>

    <!-- Tailwind CSS -->
       <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Custom CSS - SUDAH DIPERBAIKI -->
    <link rel="stylesheet" href="/assets/css/style.css">

    <style>
        /* Extra CSS kecil untuk notifikasi dan toggle icon */
        .notification-dot {
            display: inline-block;
            width: 0.5rem;
            height: 0.5rem;
            border-radius: 9999px;
        }
        .rotate-icon {
            transition: transform 0.2s;
        }
        .rotate-90 {
            transform: rotate(90deg);
        }
        
        /* Tambahkan CSS untuk memperbaiki scrolling */
        .main-container {
            height: 100vh;
            overflow: hidden;
        }
        
        .content-area {
            flex: 1;
            overflow-y: auto;
            height: calc(100vh - 80px); /* 80px adalah tinggi header yang baru */
        }
        
        /* Header styling yang lebih menarik */
        .header-gradient {
            background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
            border-bottom: 1px solid rgba(0, 51, 160, 0.08);
        }
        
        .header-title {
            background: linear-gradient(135deg, var(--suzuki-blue), var(--suzuki-dark));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .header-button {
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .header-button::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            border-radius: 50%;
            background: rgba(0, 51, 160, 0.1);
            transform: translate(-50%, -50%);
            transition: width 0.6s, height 0.6s;
        }
        
        .header-button:hover::before {
            width: 100px;
            height: 100px;
        }
        
        .profile-button {
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }
        
        .profile-button:hover {
            border-color: var(--suzuki-blue);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 51, 160, 0.15);
        }
        
        .notification-badge {
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% {
                box-shadow: 0 0 0 0 rgba(255, 102, 0, 0.4);
            }
            70% {
                box-shadow: 0 0 0 6px rgba(255, 102, 0, 0);
            }
            100% {
                box-shadow: 0 0 0 0 rgba(255, 102, 0, 0);
            }
        }
    </style>
</head>
<body>
    <!-- Desktop & Tablet Layout -->
    <div class="hidden sm:flex main-container">
        <!-- Sidebar -->
        <?php include 'sidebar.php'; ?>
        
        <!-- Main Content -->
        <div class="flex-1 flex flex-col">
            <!-- Header yang lebih menarik -->
            <header class="header-gradient shadow-lg z-10 flex-shrink-0">
                <div class="flex items-center justify-between px-8 py-5">
                    <div class="flex-1">
                        <h1 class="text-3xl font-bold header-title mb-1">
                            <?php echo isset($page_title) ? $page_title : 'Dashboard'; ?>
                        </h1>
                        <p class="text-sm text-gray-600 flex items-center">
                            <i class="fas fa-layer-group mr-2 text-suzuki-blue"></i>
                            <?php echo isset($page_subtitle) ? $page_subtitle : 'Suzuki Dashboard'; ?>
                        </p>
                    </div>
                    
                    <div class="flex items-center space-x-6">
                        <!-- Quick Actions (opsional) -->
                        <div class="flex items-center space-x-3">
                            <button class="header-button p-3 text-gray-600 hover:text-suzuki-blue hover:bg-suzuki-blue/5 rounded-xl transition-all duration-300 relative">
                                <i class="fas fa-calendar-alt text-lg"></i>
                                <span class="absolute -top-1 -right-1 w-5 h-5 bg-suzuki-orange text-white text-xs rounded-full flex items-center justify-center font-semibold">3</span>
                            </button>
                            
                            <button class="header-button p-3 text-gray-600 hover:text-suzuki-blue hover:bg-suzuki-blue/5 rounded-xl transition-all duration-300">
                                <i class="fas fa-chart-line text-lg"></i>
                            </button>
                        </div>
                        
                        <!-- Notification Dropdown dengan desain baru -->
                        <div class="relative">
                            <button class="header-button relative p-3 text-gray-600 hover:text-suzuki-blue hover:bg-suzuki-blue/5 rounded-xl transition-all duration-300" onclick="toggleNotifications()">
                                <i class="fa-solid fa-bell text-lg"></i>
                                <span class="notification-badge absolute top-2 right-2 w-2.5 h-2.5 bg-orange-500 rounded-full border-2 border-white"></span>
                            </button>
                            
                            <div id="notificationDropdown" class="absolute right-0 mt-3 w-80 bg-white rounded-xl shadow-2xl hidden z-50 border border-gray-100">
                                <div class="p-4 border-b border-gray-100 bg-gradient-to-r from-suzuki-blue/5 to-suzuki-dark/5 rounded-t-xl">
                                    <div class="flex items-center justify-between">
                                        <h3 class="font-semibold text-gray-800 flex items-center">
                                            <i class="fas fa-bell mr-2 text-suzuki-blue"></i>
                                            Notifikasi
                                        </h3>
                                        <span class="text-xs bg-suzuki-orange text-white px-2 py-1 rounded-full font-semibold">
                                            <?php
                                            $sql = "SELECT COUNT(*) as count FROM notifications WHERE user_id = ? AND is_read = 0";
                                            $stmt = $conn->prepare($sql);
                                            $stmt->bind_param("i", $_SESSION['user_id']);
                                            $stmt->execute();
                                            $result = $stmt->get_result();
                                            $row = $result->fetch_assoc();
                                            echo $row['count'] . ' baru';
                                            ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="max-h-96 overflow-y-auto">
                                    <?php
                                    $sql = "SELECT * FROM notifications WHERE user_id = ? AND is_read = 0 ORDER BY created_at DESC LIMIT 5";
                                    $stmt = $conn->prepare($sql);
                                    $stmt->bind_param("i", $_SESSION['user_id']);
                                    $stmt->execute();
                                    $result = $stmt->get_result();

                                    if ($result->num_rows > 0) {
                                        while ($row = $result->fetch_assoc()) {
                                            echo '<div class="notification-item p-4 border-b border-gray-50 hover:bg-gray-50 cursor-pointer transition-colors" onclick="viewNotification(' . $row['id'] . ')">
                                                <div class="flex items-start">
                                                    <div class="w-10 h-10 bg-'.$row['color'].'-100 rounded-full flex items-center justify-center mr-3 flex-shrink-0">
                                                        <i class="fa-solid fa-'.$row['icon'].' text-'.$row['color'].'-600 text-sm"></i>
                                                    </div>
                                                    <div class="flex-1">
                                                        <p class="text-sm font-medium text-gray-800">'.$row['title'].'</p>
                                                        <p class="text-xs text-gray-500 mt-1">'.$row['message'].'</p>
                                                       
                                                    </div>
                                                </div>
                                            </div>';
                                        }
                                    } else {
                                        echo '<div class="p-8 text-center text-gray-500">
                                            <i class="fas fa-bell-slash text-3xl mb-3 text-gray-300"></i>
                                            <p>Tidak ada notifikasi baru</p>
                                        </div>';
                                    }
                                    ?>
                                </div>
                                <div class="p-3 border-t border-gray-100 bg-gray-50 rounded-b-xl">
                                    <a href="/reminder" class="w-full text-center text-sm text-suzuki-blue hover:text-suzuki-dark font-medium block py-2 hover:bg-suzuki-blue/5 rounded-lg transition-colors">
                                        <i class="fas fa-arrow-right mr-2"></i>
                                        Lihat Semua Notifikasi
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Profile Dropdown dengan desain baru -->
                        <div class="relative">
                            <button class="profile-button flex items-center text-gray-700 focus:outline-none bg-white rounded-xl p-2 pr-4 shadow-sm" onclick="toggleProfileMenu()">
                                <img src="https://picsum.photos/seed/<?php echo $_SESSION['username']; ?>/40/40.jpg" alt="Profile" class="w-10 h-10 rounded-lg">
                                <div class="ml-3 text-left">
                                    <p class="text-sm font-semibold text-gray-800"><?php echo ucfirst($_SESSION['username']); ?></p>
                                    <p class="text-xs text-gray-500">Administrator</p>
                                </div>
                                <i class="fa-solid fa-chevron-down ml-3 text-xs text-gray-400"></i>
                            </button>
                            
                            <div id="profileMenu" class="absolute right-0 mt-3 w-56 bg-white rounded-xl shadow-xl py-2 hidden z-50 border border-gray-100">
                                <div class="px-4 py-3 border-b border-gray-100">
                                    <p class="text-sm font-semibold text-gray-800"><?php echo ucfirst($_SESSION['username']); ?></p>
                                    <p class="text-xs text-gray-500"><?php echo $_SESSION['email']; ?></p>
                                </div>
                                <a href="/akun" class="flex items-center px-4 py-3 text-sm text-gray-700 hover:bg-suzuki-blue/5 transition-colors">
                                    <i class="fas fa-user mr-3 text-suzuki-blue"></i>
                                    Profil Saya
                                </a>
                                <a href="/pengaturan" class="flex items-center px-4 py-3 text-sm text-gray-700 hover:bg-suzuki-blue/5 transition-colors">
                                    <i class="fas fa-cog mr-3 text-suzuki-blue"></i>
                                    Pengaturan
                                </a>
                                <hr class="my-2 border-gray-100">
                                <a href="/logout" class="flex items-center px-4 py-3 text-sm text-red-600 hover:bg-red-50 transition-colors">
                                    <i class="fas fa-sign-out-alt mr-3"></i>
                                    Keluar
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </header>
            
            <!-- Content Area dengan scrolling -->
            <div class="content-area bg-gray-50">
                <!-- Konten halaman akan dimuat di sini -->