<?php
session_start();

// Jika sudah login → redirect ke clean URL /dashboard
if (!empty($_SESSION['user_id'])) {
    header("Location: /dashboard");
    exit();
}

// Fungsi untuk mendapatkan IP address pengguna
function getUserIP() {
    $ipaddress = '';
    if (isset($_SERVER['HTTP_CLIENT_IP']))
        $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
    else if(isset($_SERVER['HTTP_X_FORWARDED_FOR']))
        $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
    else if(isset($_SERVER['HTTP_X_FORWARDED']))
        $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
    else if(isset($_SERVER['HTTP_FORWARDED_FOR']))
        $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
    else if(isset($_SERVER['HTTP_FORWARDED']))
        $ipaddress = $_SERVER['HTTP_FORWARDED'];
    else if(isset($_SERVER['REMOTE_ADDR']))
        $ipaddress = $_SERVER['REMOTE_ADDR'];
    else
        $ipaddress = 'UNKNOWN';
    return $ipaddress;
}

// Fungsi untuk mendapatkan informasi browser
function getBrowser() {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    $browser = "Unknown Browser";
    
    $browser_array = array(
        '/msie/i'       =>  'Internet Explorer',
        '/firefox/i'    =>  'Firefox',
        '/safari/i'     =>  'Safari',
        '/chrome/i'     =>  'Chrome',
        '/edge/i'       =>  'Edge',
        '/opera/i'      =>  'Opera',
        '/netscape/i'   =>  'Netscape',
        '/maxthon/i'    =>  'Maxthon',
        '/konqueror/i'  =>  'Konqueror',
        '/mobile/i'     =>  'Handheld Browser'
    );
    
    foreach ($browser_array as $regex => $value) {
        if (preg_match($regex, $user_agent)) {
            $browser = $value;
        }
    }
    
    return $browser;
}

// Fungsi untuk mendapatkan informasi device
function getDevice() {
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    
    if (preg_match('/mobile/i', $user_agent)) {
        return 'Mobile';
    } elseif (preg_match('/tablet/i', $user_agent)) {
        return 'Tablet';
    } else {
        return 'Desktop';
    }
}

// Fungsi untuk mendapatkan lokasi berdasarkan IP (sederhana)
function getLocation($ip) {
    // Menggunakan API gratis untuk mendapatkan lokasi
    $location_data = @file_get_contents("http://ip-api.com/json/{$ip}");
    if ($location_data) {
        $location = json_decode($location_data);
        if ($location && $location->status == 'success') {
            return $location->city . ', ' . $location->country;
        }
    }
    return 'Unknown';
}

// Fungsi untuk mencatat login history
function logLoginAttempt($conn, $user_id, $status) {
    $ip_address = getUserIP();
    $device = getDevice();
    $browser = getBrowser();
    $location = getLocation($ip_address);
    
    $sql = "INSERT INTO login_history (user_id, ip_address, device, browser, location, status) 
            VALUES (?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("isssss", $user_id, $ip_address, $device, $browser, $location, $status);
    $stmt->execute();
}

// FUNGSI BARU: Membuat notifikasi
function createNotification($conn, $user_id, $title, $message, $type, $icon, $color) {
    $sql = "INSERT INTO notifications (user_id, title, message, type, icon, color, is_read) 
            VALUES (?, ?, ?, ?, ?, ?, 0)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("isssss", $user_id, $title, $message, $type, $icon, $color);
    $stmt->execute();
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    require_once '../config/database.php';

    $username = sanitize_input($_POST['username']);
    $password = $_POST['password'];

    // Query untuk mendapatkan data user
    $sql = "SELECT id, username, name, email, password, role FROM users WHERE username = ? OR email = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $username, $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();

        if (password_verify($password, $row['password'])) {
            // Set SESSION
            $_SESSION['user_id']  = $row['id'];
            $_SESSION['username'] = $row['username'];
            $_SESSION['name']     = $row['name'];
            $_SESSION['email']    = $row['email'];
            $_SESSION['role']     = $row['role'];
            
            // 1. Catat login berhasil ke history
            logLoginAttempt($conn, $row['id'], 'success');

            // 2. Buat notifikasi login berhasil
            $notif_title = "Login Berhasil";
            $notif_message = "Selamat datang kembali, " . $row['name'] . "! Anda telah berhasil masuk dari " . getDevice() . ".";
            $notif_type = "success";
            $notif_icon = "fa-check-circle";
            $notif_color = "green";
            createNotification($conn, $row['id'], $notif_title, $notif_message, $notif_type, $notif_icon, $notif_color);

            // Redirect ke dashboard
            header("Location: /dashboard");
            exit();
        } else {
            // Password salah
            // 1. Catat login gagal ke history
            logLoginAttempt($conn, $row['id'], 'failed');

            // 2. Buat notifikasi login gagal
            $notif_title = "Upaya Login Gagal";
            $notif_message = "Kami mendeteksi percobaan login ke akun Anda dengan password yang salah dari IP: " . getUserIP();
            $notif_type = "warning";
            $notif_icon = "fa-exclamation-triangle";
            $notif_color = "yellow";
            createNotification($conn, $row['id'], $notif_title, $notif_message, $notif_type, $notif_icon, $notif_color);

            $error = "Password salah. Silakan coba lagi.";
        }
    } else {
        // Username/email tidak ditemukan
        // Hanya catat ke history, tidak perlu notifikasi untuk keamanan
        logLoginAttempt($conn, null, 'failed');
        $error = "Username atau email tidak ditemukan.";
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Suzuki Dashboard</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
</head>
<body class="w-screen h-screen overflow-hidden">
    <div class="flex w-full h-full">

        <!-- LEFT SIDE (MATRIX ANIMATION) -->
        <div class="hidden md:flex w-1/2 bg-black items-center justify-center relative overflow-hidden">
            <canvas id="matrixCanvas" class="absolute inset-0 w-full h-full"></canvas>
            <div class="absolute bottom-10 text-green-400 text-xl font-semibold animate-fadeIn z-10">
                Selamat Datang di Suzuki Dashboard
            </div>
        </div>

        <!-- RIGHT SIDE (LOGIN FORM) -->
        <div class="w-full md:w-1/2 bg-white flex items-center justify-center p-10 animate-slideIn">
            <div class="w-full max-w-md">
                <div class="flex flex-col items-center mb-6">
                    <div class="w-20 h-20 bg-blue-600 rounded-xl flex items-center justify-center shadow-md">
                        <i class="fas fa-right-to-bracket text-white text-3xl"></i>
                    </div>
                    <h1 class="text-3xl font-bold text-gray-800 mt-4">Suzuki Dashboard</h1>
                    <p class="text-gray-500 text-sm">Silakan masuk untuk melanjutkan</p>
                </div>

                <?php if (isset($error)): ?>
                    <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4">
                        <span><?php echo $error; ?></span>
                    </div>
                <?php endif; ?>

                <form action="/login" method="post" class="space-y-5">
                    <div>
                        <label for="username" class="block font-medium text-gray-700 mb-1">Username atau Email</label>
                        <input type="text" id="username" name="username" required
                            class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none">
                    </div>

                    <div>
                        <label for="password" class="block font-medium text-gray-700 mb-1">Password</label>
                        <input type="password" id="password" name="password" required
                            class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-blue-500 outline-none">
                    </div>

                    <button type="submit"
                        class="w-full bg-blue-600 hover:bg-blue-700 text-white font-semibold py-2 rounded-lg transition-all duration-200 shadow-md">
                        Masuk
                    </button>
                </form>

                <div class="text-center mt-4">
                    <a href="#" class="text-blue-600 hover:underline text-sm font-medium">Lupa password?</a>
                </div>
            </div>
        </div>
    </div>

    <!-- Custom Animations -->
    <style>
        @keyframes slideIn {
            from { opacity: 0; transform: translateX(40px); }
            to { opacity: 1; transform: translateX(0); }
        }
        .animate-slideIn {
            animation: slideIn 0.8s ease-out forwards;
        }

        @keyframes pulse-slow {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }
        .animate-pulse-slow {
            animation: pulse-slow 4s ease-in-out infinite;
        }

        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }
        .animate-fadeIn {
            animation: fadeIn 2s ease-in forwards;
        }
    </style>
<script>
        const canvas = document.getElementById("matrixCanvas");
        const ctx = canvas.getContext("2d");

        canvas.width = canvas.offsetWidth;
        canvas.height = canvas.offsetHeight;

        // ASTRONAUT FLOATING PARTICLES ANIMATION
        const stars = [];
        const starCount = 180;

        function createStar() {
            return {
                x: Math.random() * canvas.width,
                y: Math.random() * canvas.height,
                size: Math.random() * 2 + 1,
                speed: Math.random() * 0.8 + 0.2,
                depth: Math.random() * 1.5 + 0.5
            };
        }

        for (let i = 0; i < starCount; i++) stars.push(createStar());

        function drawSpace() {
            ctx.clearRect(0, 0, canvas.width, canvas.height);

            // Stars
            stars.forEach((s, i) => {
                ctx.fillStyle = `rgba(255,255,255,${0.7 * s.depth})`;
                ctx.beginPath();
                ctx.arc(s.x, s.y, s.size, 0, Math.PI * 2);
                ctx.fill();

                s.y += s.speed * s.depth;
                if (s.y > canvas.height) {
                    stars[i] = createStar();
                    stars[i].y = 0;
                }
            });
        }

        setInterval(drawSpace, 30);
    </script>
</body>
</html>