<?php
session_start();
require '../config.php';
require '../lib/header.php';
?>
<div class="content-wrapper">

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="m-t-0 text-center header-title"><i class="ri-shuffle-line mr1 text-primary"></i> Dokumentasi API PPOB</h4>
                    <hr>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <tr>
                                <th width="50%">METODE HTTP</th>
                                <td>POST</td>
                            </tr>
                            <tr>
                                <th>API URL</th>
                                <td><?php echo $config['web']['url']; ?>api/ppob</td>
                            </tr>
                            <tr>
                                <th>API KEY</th>

                                <td style="min-width: 80px;">
                                    Create Your Api Key <a href="/user/setting">craete api</a>
                                </td>
                            </tr>
                            <tr>
                                <th>FORMAT RESPON</th>
                                <td>JSON</td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div><br>

            <div class="row">
                <div class="col-md-6 grid-margin stretch-card">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="header-title m-t-0">Pemesanan
                            </h4>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Parameter</th>
                                            <th>Deskripsi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th>API URL</th>
                                            <td><?php echo $config['web']['url']; ?>api/ppob</td>
                                        </tr>
                                        <tr>
                                            <td>api_key</td>
                                            <td>API KEY Anda</td>
                                        </tr>
                                        <tr>
                                            <td>action</td>
                                            <td>pemesanan</td>
                                        </tr>
                                        <tr>
                                            <td>Layanan</td>
                                            <td>Service ID <a href="<?php echo $config['web']['url']; ?>halaman/harga-ppob">Daftar Layanan</a></td>
                                        </tr>
                                        <tr>
                                            <td>target</td>
                                            <td>Target / Tujuan</td>
                                        </tr>
                                        <tr>
                                            <td>no_meter</td>
                                            <td>No HP (Jika Pemesanan Pulsa)</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <b>Contoh Respon Yang Di Dapat</b><br />
                            <div class="alert alert-success-2">
                                <pre>
Jika Pemesanan Sukses
{
    "data": {
    "id": "401"
    }
}

Jika Pemesanan Gagal
{
    "status": false,
    "data": {
    "pesan": "Permintaan Tidak Sesuai"
    }
}
</pre>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end col -->
                <div class="col-md-6 grid-margin stretch-card">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="header-title m-t-0">Status Pesanan
                            </h4>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Parameter</th>
                                            <th>Deskripsi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th>API URL</th>
                                            <td><?php echo $config['web']['url']; ?>api/ppob</td>
                                        </tr>
                                        <tr>
                                            <td>api_key</td>
                                            <td>API KEY Anda</td>
                                        </tr>
                                        <tr>
                                            <td>action</td>
                                            <td>status</td>
                                        </tr>
                                        <tr>
                                            <td>id</td>
                                            <td>Order ID</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <b>Contoh Respon Yang Didapat</b><br />
                            <div class="alert alert-success-2">
                                <pre>
Jika Respon Sukses
{
    "data": {
    "id":"40",
    "status":"Success",
    "catatan":"SN : 09220xxxxxxxx"
    }
}

Jika Respon Gagal
{
    "status": false,
    "data": {
    "pesan": "Permintaan Tidak Sesuai"
    }
}
</pre>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- end col -->
                <div class="col-md-12 grid-margin stretch-card">
                    <div class="card">
                        <div class="card-body">
                            <h4 class="header-title m-t-0">Layanan
                            </h4>
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Parameter</th>
                                            <th>Deskripsi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <th>API URL</th>
                                            <td><?php echo $config['web']['url']; ?>api/ppob</td>
                                        </tr>
                                        <tr>
                                            <td>api_key</td>
                                            <td>API KEY Anda</td>
                                        </tr>
                                        <tr>
                                            <td>action</td>
                                            <td>layanan</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <b>Contoh Respon Yang Di Dapat</b><br />
                            <div class="alert alert-success-2">
                                <pre>
Jika Respon Sukses
{
    "data": {
    "sid": "1"
    "operator": "TSEL"
    "layanan": "TSEL 50000"
    "harga": "51000"
    "status": "Normal"
    "keterangan": "Pulsa Telkomsel 5.000"
    }
}

Jika Respon Gagal
{
    "status": false,
    "data": {
    "pesan": "Permintaan Tidak Sesuai"
    }
}
</pre>
                            </div>
                        </div>
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->

            </div>
            <!-- end container -->
        </div>
        <!-- end content -->
    </div>

</div>
<?php
require '../lib/footer.php';
?>