<?php
session_start();
require '../config.php';
require '../lib/session_user.php';
require '../lib/session_login.php';
require '../lib/database.php';
require '../lib/csrf_token.php';

if (isset($_GET['oid'])) {
    $kode_pesanan = filter($_GET['oid']);

    $cek_pesanan = $conn->query("SELECT * FROM pembelian_ppob WHERE oid = '$kode_pesanan' AND user = '$sess_username'");
    $data_pesanan = mysqli_fetch_assoc($cek_pesanan);

    if ($data_pesanan['status'] == "Pending") {
        $label = "warning";
    } else if ($data_pesanan['status'] == "Error") {
        $label = "danger";
    } else if ($data_pesanan['status'] == "Success") {
        $label = "success";
    }

    if ($cek_pesanan->num_rows == 0) {
        header("Location: " . $config['web']['url'] . "/halaman/riwayat-ppob");
    } else {
?>
        <!DOCTYPE html>
        <html lang="en">

        <head>
            <!-- Required meta tags -->
            <meta charset="utf-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
            <title><?php echo strtoupper($data['short_title']); ?> : <?php echo strtoupper($data['title']); ?></title>
            <meta name="description" content="<?php echo $data['deskripsi_web']; ?>">
            <meta name="keywords" content="<?php echo $data['keyword']; ?>">

            <!--ICON LOGO-->
            <link rel="shortcut icon" type="image/ico" href="/assets/images/favicon/<?php echo $data['favicon']; ?>" />
            <!--END ICON LOGO-->
            <link rel="stylesheet" href="/assets/vendors/mdi/css/materialdesignicons.min.css">
            <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
        </head>

        <body>

            <div class="kt-invoice__head">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="kt-invoice__head">
                                    <h4 class="m-t-0 text-uppercase text-center header-title"> </h4>
                                    <!-- Start Content -->
                                    <div class="kt-container kt-grid__item kt-grid__item--fluid">
                                        <!-- Start Page Order Struk -->
                                        <div class="row">
                                            <div class="offset-lg-2 col-lg-8">
                                                <div class="kt-portlet">
                                                    <div class="kt-portlet__body">
                                                        <div class="text-center"><img src="/assets/images/header-logo/<?php echo $data['header_logo']; ?>" width="140px" height="40px"></div>
                                                        <h5 style="padding-top:10px" class="text-center"><strong>
                                                            </strong></h5>
                                                        <br />
                                                        <center>
                                                            <h4>
                                                                <font><b>STRUK PEMBELIAN</b></font><br>
                                                                ID : <?php echo $data_pesanan['oid']; ?>
                                                            </h4><br>
                                                            <font style="font-style: italic"><?php echo tanggal_indo($data_pesanan['date']); ?>, <?php echo $data_pesanan['time']; ?></font>
                                                        </center>
                                                        <br />
                                                        <div class="cart">
                                                            <div class="table-responsive">
                                                                <table class="table table-bordered table-sm">
                                                                    <tr>
                                                                        <td>Jenis Layanan</td>
                                                                        <td>: <?php echo $data_pesanan['layanan']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>Tujuan/No</td>
                                                                        <td>: <?php echo $data_pesanan['target']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>Total Bayar</td>
                                                                        <td contenteditable="true">: Rp. <?php echo number_format($data_pesanan['harga'], 0, ',', '.'); ?>,-</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>Status</td>
                                                                        <td>: <?php echo $data_pesanan['status']; ?></td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td>Note/Keterangan</td>
                                                                        <td contenteditable="true">: <?php echo $data_pesanan['keterangan']; ?></td>
                                                                    </tr>
                                                                </table>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <br><br><br>
                                                    <center>
                                                        <a href="<?php echo $config['web']['url']; ?>halaman/riwayat-ppob" class="btn btn-dark btn-elevate btn-pill btn-elevate-air">Kembali</a>
                                                        <a class="pull-right btn btn-dark btn-elevate btn-pill btn-elevate-air" href="#" onClick="window.print();"><i class="mdi mdi-printer"></i> Print</a>
                                                    </center>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- End Page Order Struk -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Content -->
            <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
            <script src="https://cdn.jsdelivr.net/npm/popper.js@1.14.3/dist/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49" crossorigin="anonymous"></script>
            <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.1.3/dist/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" crossorigin="anonymous"></script>
        </body>

        </html>
<?php
        //require '../lib/footer.php';
    }
} else {
    header("Location: " . $config['web']['url'] . "halaman/riwayat-ppob");
}
?>